#include <stdio.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sched.h>
#include <sys/types.h>
#include <unistd.h>
#include <iostream>
#include <sys/time.h>
#include <sys/resource.h>
#include <signal.h>
#include <list>
#include <math.h>
#include <pthread.h> 
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "sched.h"

using namespace std;

#define MSG_DELAY 1000000000//1E9
#define MSG_LOOPS 10
#define DEFAULT_PRIO 0;
#define DEFAULT_PERIOD 12;
#define MAXBUFLEN 256

//#define DEBUG

bool end;
long int record_count = 0;
long int mcount = 0, scount = 0;
double startup_time = 0.0, current_time = 0.0, past_time = 0.0, sleep_time = 0.0;
bool set_fifo = false;
int current_job = 0, current_pid = 0, current_index = 0;
char	filename[255]="data.txt";
FILE	*handler;
double record_time = 0.0;

#ifdef _KURT
int kurtdev;
#endif

//unset fifo and resume all processes before exit(-1)
void kill(VSchedConfig &config)
{ 
  int iter;
	struct sched_param sched;
	sched.sched_priority = 0; //99, max
	
	for(iter = 0; iter <= config.numprocs; iter++)
	{
		if(config.process[iter].valid)
		{
			if( sched_setscheduler( config.process[iter].pid, SCHED_OTHER, &sched ) == -1 )
			{
					cout << "ERROR IN SETTING THE SCHEDULER DOWN" << endl;
					exit(-1);
			}
		}
	}
	
	int priority = 19;
	int ret;
	
	for(iter = 0; iter <= config.numprocs; iter++)
	{
			if(config.process[iter].valid)
			{
				ret = setpriority(PRIO_PROCESS, config.process[iter].pid, priority);
				config.process[iter].priority = priority;
				
				if(kill(config.process[iter].pid, SIGKILL) == -1)
				{
					cout << "error in resuming process: " << config.process[iter].pid << endl;
					exit(-1);
				}
			}
	}
}

void cleanup(VSchedConfig &config)
{
	close(config.pp[0]);
	
	#ifdef KURT
  /* Return the kernel to non-real-time mode */
	switch_to_normal(kurtdev, 0);
	#endif
	
	kill(config); 
	fclose(handler);
  exit(-1);						
}

int verify(int pid, int priority, int policy)
{
	//verifying
	/*
	SCHED_OTHER		0
	SCHED_FIFO		1
	SCHED_RR		2
	*/
	struct sched_param sched;
	if(sched_getscheduler(pid) != policy)
	{
		printf("Policy verification fails! current policy is %d while it should be %d\n", sched_getscheduler(pid), policy);
		return -1;
	}
	
	if(policy == 1)
	{
		sched_getparam(pid, &sched);
		if(sched.sched_priority != priority)
		{
			printf("FIFO priority verification fails! current priority is %d while it should be %d\n", sched.sched_priority, priority);
			return -1;
		}
	}
	
	if(policy == 0)
	{
		if(getpriority(PRIO_PROCESS, pid) != priority)
		{
			printf("OTHER priority verification fails! current priority is %d while it should be %d\n", getpriority(PRIO_PROCESS, pid), priority);
			return -1;
		}
	}	
	return 0;
}

void setfifo(VSchedConfig &config)
{
	
	for(int iter = 0; iter <= config.numprocs; iter++)
	{
		struct sched_param sched;

		if(config.process[iter].valid)
		{
			if(config.process[iter].pid == current_pid)
			{	
				sched.sched_priority = 90; //99, max
			}
			else
			{
				sched.sched_priority = 1; //99, max
			}
			
			if( sched_setscheduler( config.process[iter].pid, SCHED_FIFO, &sched ) == -1 )  //can be replaced by rt_task_init_schmod()
			{
				cout << "ERROR IN SETTING THE SCHEDULER UP" << endl;
				cleanup(config);
			}
			else
			{
				//printf("set process %d SCHED_FIFO with static priority %d \n", config.process[iter].pid, sched.sched_priority);
				config.process[iter].priority = sched.sched_priority;
			}
		}
	}
}

void unsetfifo(VSchedConfig &config)
{
	int iter;
	
	//printf("\nunset FIFO to all processes\n");	
	for(iter = 0; iter <= config.numprocs; iter++)
	{
		struct sched_param sched;
		sched.sched_priority = 0; //99, max
	
		if(config.process[iter].valid)
		{
			if( sched_setscheduler( config.process[iter].pid, SCHED_OTHER, &sched ) == -1 )  //can be replaced by rt_task_init_schmod()
			{
					cout << "ERROR IN SETTING THE SCHEDULER DOWN" << endl;
					cleanup(config);
			}
			//else
					//printf("set process %d SCHED_OTHER with static priority %d\n", config.process[iter].pid, sched.sched_priority);
		}
	}
	
	int priority = 19;
	int ret;
	
	//printf("set SCHED_OTHER with priority 19 to all processes\n\n");
	for(iter = 0; iter <= config.numprocs; iter++)
	{
			if(config.process[iter].valid)
			{
				ret = setpriority(PRIO_PROCESS, config.process[iter].pid, priority);
				config.process[iter].priority = priority;
			}
	}
			
}

void suspend(VSchedConfig &config)
{
	
	//printf("\nsuspend all processes\n");
	for(int iter = 0; iter <= config.numprocs; iter++)
	{
		if(config.process[iter].valid)
		{
			if(kill(config.process[iter].pid,SIGSTOP) == -1)
			{
				cout << "error in suspending process: " << config.process[iter].pid << endl;
				cleanup(config);
			}
		}
	}

}

void resume(VSchedConfig &config)
{
	//printf("\nresume processes\n\n");
	for(int iter = 0; iter <= config.numprocs; iter++)
	{
		if((config.process[iter].valid) && (config.process[iter].suspended == false))
		{
			if(config.FIFO) //resume all processes and let Linux FIFO schedule
			{
				if(kill(config.process[iter].pid,SIGCONT) == -1)
				{
						cout << "error in resuming process: " << config.process[iter].pid << endl;
						cleanup(config);
				}
			}
			else //only resume current process
			{
				if(config.process[iter].pid == current_pid)
				{
					if(kill(config.process[iter].pid,SIGCONT) == -1)
					{
							cout << "error in resuming process: " << config.process[iter].pid << endl;
							cleanup(config);
					}
				}
			}
		}
	}
}

void record(double miss_deadline, int c_pid, double c_period, double c_slice, int m_pid, double m_period, double m_slice)
{
	struct timeval tv_record;
	
	gettimeofday(&tv_record, NULL);
  record_time = (double)(tv_record.tv_sec)+(double)(tv_record.tv_usec)/1e6;
	fprintf(handler, "%ld %ld %lf %lf %d % lf %lf %d %lf %lf\n", mcount, scount, record_time, miss_deadline, c_pid, c_period, c_slice, m_pid, m_period, m_slice);
	
	record_count++;
	
	if(( record_count % 1000 )== 0)
	{
  	record_count = 0;
  	fflush(handler);
  }
  
}
	
void Scheduler(VSchedConfig &config) 
{
#ifdef DEBUG  
	int pass=0;
#endif
  int count;
	struct sched_param mysched;
	struct timeval tv, tv1, tv2, timeout;
	handler = fopen(filename, "w+");
	
#ifdef _KURT	
	//************ begin of kurt *******************//
	cout << "loading kurt..." << endl;
	struct rtparams rt_param;

	/* Open /dev/kurt */
	kurtdev = kurt_open();

	/* set the scheduling mode to be KURT_ANYTIME
	 * and then set the rt_id of this procss properly
	 */
	rt_param.rt_id = ASSIGN_RT_ID; //ASSIGN_RT_ID_FROM_TOP;
	rt_param.period = 0;
	#ifdef CONFIG_RT_ENFORCEMENT
	rt_param.exec_time = 0;
	#endif
	rt_param.rt_mode = KURT_ANYTIME;
	rt_param.rt_name[0] = '\0';
	#ifdef CONFIG_SMP
	rt_param.processor = 0;
	#endif

	if (set_rtparams(kurtdev, getpid(), RT_REGISTER, &rt_param) < 0) 
	{
		perror("set_rtparams");
		exit(1);
	} 
	else
	{
		get_rtparams(kurtdev, getpid(), &rt_param);
		cout << "KURT process rt_id: " << rt_param.rt_id << endl;
	}
		
	/* Declare this task as the scheduling task */	
	set_scheduling_task(kurtdev);
	
	/* Switch kernel to real-time mode */
	switch_to_rt(kurtdev, SCHED_KURT_PREFERRED, NULL, 0);
	//*********** end of kurt ***********************//
#endif
	
	cout << "scheduler pid: " << getpid() << endl;	
	mysched.sched_priority = config.prio; //99, max
  if( sched_setscheduler(0, SCHED_FIFO, &mysched ) == -1 )  //can be replaced by rt_task_init_schmod()
		{
			cout << "ERROR IN SETTING THE SCHEDULER UP" << endl;
			perror( "errno" );
			exit( 0 );
		}
	else
			cout << "set scheduler SCHED_FIFO with static priority " << mysched.sched_priority << endl;

	cout << "Scheduling starts!" << endl;
	end = false;
	
	fd_set readfds;
	FD_ZERO(&readfds);
  FD_SET(config.pp[0], &readfds);
  char line[10];    
  int n_select;
  
  mcount = 0;
  scount = 0;
	cout << "RESOLUTION: " << RESOLUTION << endl;      
	while(!end) 
	{
#ifdef DEBUG
	  if ((pass==20)) //add code to check whether the array is empty
	  { 
	    end = true;
	    printf("Scheduling finished!\n");
	    kill(config);
	    config.Unlock();
	    exit(-1);
	  } 
	  else 
	  {
	    pass++;
	  }
#endif

start:
#ifdef DEBUG
	  cout << "mcount:scount = " << mcount << ":" << scount << endl;
#endif
		
		config.Sort();
		//cout << config << endl;	

		count = 0;
		
		config.Lock();
		//if new job is just a place-holder for next scheduling event, search next job 
		while((config.process[count].valid) && (config.process[count].suspended == false) && (config.process[count].left == 0.0) && (count <= config.numprocs))	
		{
				count++;
		}
		
		gettimeofday(&tv, NULL);
    current_time = (double)(tv.tv_sec)+(double)(tv.tv_usec)/1e6;
    //cout << "selecting jobs...:current time is " << current_time << endl;
    sleep_time = 0.0;
    set_fifo = false;
    			
		if((!config.process[0].valid) || ((config.process[0].valid) && (config.process[0].suspended == true)))
		{		
				config.Unlock();
				
				cout << "mcount:scount = " << mcount << ":" << scount << endl;
				mcount = 0;
				scount = 0;
				//cout << "the process list is empty, put scheduler into sleeping..." << endl;
    		while((!config.process[0].valid) || ((config.process[0].valid) && (config.process[0].suspended == true)))
				{					
						timeout.tv_sec = 0;
    				timeout.tv_usec = (long)(RESOLUTION*1000000);
				
						FD_ZERO(&readfds);
    				FD_SET(config.pp[0], &readfds);
						n_select = select(config.pp[0]+1, &readfds, NULL, NULL, &timeout);
    				if(n_select > 0)
    				{
    						cout << "scheduler wakes up" << endl;
    						read(config.pp[0], line, 10);
    						cout << "new job arrives during idle, get signal:" << line << endl;
    						goto start;
    				}
    				else if(n_select == -1)
    				{
    						cout << "select() error during idle" << endl;
								cleanup(config);
    				}
				}
		}
		else
		if((count > config.numprocs) || ((count <= config.numprocs) && (!config.process[count].valid)))
		{
				//cout << "all jobs are finished before deadlines!" << endl;
				
				if(current_time > config.process[0].next_deadline)
				{
					//cout << "no time/too late to sleep, adjusting..." << endl;
					
    			record(config.process[0].next_deadline, config.process[current_job].pid, config.process[current_job].period_ms, config.process[current_job].slice_ms, config.process[0].pid, config.process[0].period_ms, config.process[0].slice_ms);
    			
    			config.process[0].left = config.process[0].slice_ms / 1000.0;
    			config.process[0].next_deadline = config.process[0].period_ms / 1000.0 + current_time;
    			
    			config.Unlock(); 
    			mcount = mcount + 1; 			
					goto start;		
				}
				else
					sleep_time = config.process[0].next_deadline - current_time;
				
		}
		else	//iter points to the new job with unfinished cycle
		{
				current_job = count;
				current_pid = config.process[current_job].pid;
				
				//if new job's slice can not be finished before next scheduling event happens
				if(current_time > config.process[0].next_deadline)
				{
					//cout << "current picked job: " << config.process[current_job].pid << endl;
					//cout << "fail to meet the deadline of job: " << config.process[0].pid << " adjusting..." << endl;
					
    			record(config.process[0].next_deadline, config.process[current_job].pid, config.process[current_job].period_ms, config.process[current_job].slice_ms, config.process[0].pid, config.process[0].period_ms, config.process[0].slice_ms);
    			
					config.process[0].left = config.process[0].slice_ms / 1000.0;
    			config.process[0].next_deadline = config.process[0].period_ms / 1000.0 + current_time;
    		
    			config.Unlock();	
    			mcount = mcount + 1;	
					goto start;		
							
				}
				else
				if((config.process[current_job].left + current_time) >= config.process[0].next_deadline)	
				{
						//cout << "new job's slice can not be finished before next scheduling event happens!" << endl;
						sleep_time = config.process[0].next_deadline - current_time; //sleep until next scheduling event happens
						config.process[current_job].left = config.process[current_job].left - sleep_time;
				}
				else
				{
						//cout << "new job's slice can be finished before next scheduling event happens!\n";
						sleep_time = config.process[current_job].left;	//sleep until new job's slice finishes
						config.process[current_job].left = 0;
				}

				scount = scount + 1;
				//cout << "setting fifo and start the new job: " << config.process[current_job].pid << endl;
				
				resume(config);	//start new job
				setfifo(config);
				set_fifo = true;
 		}
    config.Unlock();
   
    //new job may be inserted here....
		if(sleep_time > 0)
		{
    	gettimeofday(&tv1, NULL);

    	timeout.tv_sec = (long)floor(sleep_time);
    	timeout.tv_usec =(long)((sleep_time - (double)timeout.tv_sec)*1000000);
    	//cout << "scheduler sleeps for " << timeout.tv_sec << " sec " << timeout.tv_usec << " usec" <<endl;
    	
    	if((timeout.tv_sec < 0) || (timeout.tv_usec < 0))
    	{
    		cout << "sleep time (before select) error" << endl;
    		cleanup(config);
    	}
    	
    	FD_ZERO(&readfds);
    	FD_SET(config.pp[0], &readfds);
    	n_select = select(config.pp[0]+1, &readfds, NULL, NULL, &timeout);
    	if(n_select > 0)
    	{
				if(set_fifo)
				{    				
    				//cout << "unsetting fifo and suspend current job: " << current_pid << endl;	  	
    				current_index = config.GetPid(current_pid);
    				//cout << "current index found: " << current_index << endl;
    				
    				if(current_index >= 0 )
    				{    				
    					config.Lock();
    					suspend(config);	//suspend current job
    					unsetfifo(config);
    					set_fifo = false;
	
							//update current job
    					gettimeofday(&tv2, NULL);
    					past_time = (double)(tv2.tv_sec-tv1.tv_sec)+(double)((tv1.tv_usec-tv2.tv_usec)/1e6);
    					//cout << "past_time:" << past_time << endl;
    					config.process[current_index].left = config.process[current_index].left + (sleep_time - past_time);
    					config.Unlock();
    				}
    		}	
    		
    		read(config.pp[0], line, 10);
    		cout << "new job arrives during busy, get signal:" << line;
    	  
    		goto start;
    	}
    	else if(n_select == -1)
    	{
    		cout << "select() error" << endl;
    		cleanup(config);
    	}
    	else //select == 0
    	{
    		//cout << "finish sleeping, sleep time:" << sleep_time << endl;
    	}
		}
		else
		if(sleep_time < 0)
		{
			cout << "sleep_time: " << sleep_time <<" error" << endl;
			cleanup(config);
		}
    		
		config.Lock();
		if(set_fifo)
		{
				//cout << "unset fifo and suspend current job: " << config.process[current_job].pid << endl;  	
    		suspend(config);	//suspend current job
    		unsetfifo(config);
    		set_fifo = false;
    }
	
		gettimeofday(&tv, NULL);
    current_time = (double)(tv.tv_sec)+(double)(tv.tv_usec)/1e6;
    //cout << "current time after sleep is " << current_time << endl;
    
    if((config.process[0].valid)  || ((config.process[0].valid) && (config.process[0].suspended == true)))
    {
    	if((fabs(current_time - config.process[0].next_deadline) < RESOLUTION ) && (config.process[0].left == 0.0))
    	{
    		//update the placeholder and insert a new job into the queue
				//cout << "***update the placeholder and insert a new job: " << config.process[0].pid << "into the queue" << endl;
    		
    		config.process[0].left = config.process[0].slice_ms / 1000.0;
    		config.process[0].next_deadline = config.process[0].period_ms / 1000.0 + current_time;
    	}
    }
    
    config.Unlock();
		
	}	//end WHILE()
	
	//never reach here
	cleanup(config);
}


