#ifndef _config
#define _config

#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <list>
#include <iostream>

#ifdef _KURT
#include <linux/mutime.h>
#include <linux/rt.h>
#endif

using namespace std;

#define RESOLUTION 0.01

#ifdef _KURT
#undef RESOLUTION
#define RESOLUTION 0.0001
#endif

#ifdef _KERNEL_2_60
#undef RESOLUTION
#define RESOLUTION 0.001
#endif


// Maximum length of a process pathname
#define MAXPATH 1024

// default number of VSCHED scheduled processes
#define DEFAULT_NUMPROC 128

// Default percentage for sched other
#define DEFAULT_SCHEDOTHER 35 //so the allowed utility is 0.65 a little bit lower than ln2(0.693) 

#define DEFAULT_BINDADDR "_"
#define DEFAULT_BINDPORT 4456


// Defaults for periods and slices
// 1 billion ms => 1 million seconds => about 11.6 days
#define DEFAULT_PERIOD_MAX 1000000000
// 10 ms - about the timing limit of the default linux timer
// 1 ms would be appropraite on a 2.6 kernel
// smaller periods on an RTAI or KURT kernel
#define DEFAULT_PERIOD_MIN 600
#define DEFAULT_PERIOD_RES 100
#define DEFAULT_SLICE_MAX 1000000000
#define DEFAULT_SLICE_MIN 300
#define DEFAULT_SLICE_RES 100


//
// Note that these structs will be in shared memory between parent and child
// Do not use pointers unless you know what you're doing.
//

enum ProcessState {FIFO, OTHER, STOP};

struct VSchedProcess {
	
  void Init();

  // Is this a valid entry?
  bool      valid;
  pid_t     pid;
  // *Not been used yet
  unsigned  sched_admit_time;
  double  period_ms;
  double  slice_ms;
  // This indicates that the process is suspended or should be suspended 
	// at the earliest opportunity
  bool		suspended;
  // When running prior to having met its next deadline, should it run FIFO or SCHED_OTHER
  ProcessState run_type;
  // *Not been used yet, after meeting its next deadline, should it stop or run as SCHED_OTHER
  ProcessState when_done;
  // *Not been used yet
  char      pathname[1024];
  double  next_deadline;
  double  left;
  int	priority;

  ostream & Print (ostream &os);
};

inline ostream & operator << (ostream &os, VSchedProcess &p) { return p.Print(os); }

//
// This big struct contains everything shared between parent and child.
//
struct VSchedConfig {
  // For lock and unlock the assumption is that this->semaphore is the semaphore set id
  // and that semaphore 0 in the set is to be used
  // and that it was initialized to 1
  void Lock();
  void Unlock();

  // For init, we assume that the semaphore has been initialized to 1 as described above
  void Init(bool FIFO_sched, int prio, int num_procs, double sched_other_percent);
  
  ostream &Print(ostream &os);
  
  // Returns negative number on failure.
  // return the address of the process entry with given pid
  int Get(VSchedProcess &entry);
  int Set(const VSchedProcess &entry);

	void Sort();
	
  // returns number valid or -1 on error
  // return the address of the 1st free process entry, together with the index number+1
  int GetNValid(VSchedProcess output[], const int n);
  // return the address of the process entry with given pid, together with the index number
  int GetPid(const int pid);
  bool GetPid2(const int pid);
  
  int pp[2];
  
  bool 		 FIFO;
  int		 prio;
	int      numprocs;
  int      semaphore;
  // is it ready to be used?
  bool     valid;
  // do we have a hires timer (KURT/RTAI)
  bool     have_hires;
  unsigned period_min;
  unsigned period_max;
  unsigned period_res;
  unsigned slice_min;
  unsigned slice_max;
  unsigned slice_res;
  double   sched_other_percent;
  double   allocated_time_percent;

  VSchedProcess *process; // this will point to the item immediately following it

};

inline ostream & operator << (ostream &os,  VSchedConfig &p) { return p.Print(os); }

#endif
