#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <string.h>
#include <iostream>
#include <iomanip>

#include "config.h"

// For lock and unlock the assumption is that this->semaphore is the semaphore set id
// and that semaphore 0 in the set is to be used
// and that it was initialized to 1

  
void VSchedConfig::Lock()
{
  
  struct sembuf b = {0,-1,0} ;
  
  // this will block until the semaphore is ready
  if (semop(semaphore,&b,1)==-1) { 
    cerr << "Lock failed!"<<endl;
    exit(-1);
  }
  
}

void VSchedConfig::Unlock()
{
  
  struct sembuf b = {0,1,0} ;
  
  // this will return immediately
  if (semop(semaphore,&b,1)==-1) { 
    cerr << "Unlock failed!"<<endl;
    exit(-1);
  }
  
}


void VSchedConfig::Init(bool f, int p, int n, double so)
{
  Lock();
	
	FIFO=f;
	prio=p;
  numprocs=n;
  period_min=DEFAULT_PERIOD_MIN;
  period_max=DEFAULT_PERIOD_MAX;
  period_res=DEFAULT_PERIOD_RES;
  slice_min=DEFAULT_SLICE_MIN;
  slice_max=DEFAULT_SLICE_MAX;
  slice_res=DEFAULT_SLICE_RES;
  sched_other_percent=so;
  allocated_time_percent=0;
  
  // This is a hack to deal with C++ not being happy with a blah[0] field:
  process=(VSchedProcess*)((&process)+sizeof(process));

  for (int i=0;i<numprocs;i++) { 
    process[i].Init();
  }

  valid=true;

  Unlock();
}

ostream & VSchedConfig::Print(ostream &os )
{
  Lock();
  os << "Configuration: FIFO="<< FIFO<<", prio="<<prio<<", numprocs="<<numprocs<<", sempahore="<<semaphore<<", valid="<<valid
     << ", have_hires="<<have_hires<<", period_min="<<period_min<<", period_max="<<period_max
     << ", period_res="<<period_res<<", slice_min="<<slice_min<<", slice_max="<<slice_max
     << ", slice_res="<<slice_res<<", sched_other_percent="<<sched_other_percent
     << ", allocated_time_percent="<<allocated_time_percent
     << ", Active processes follow:\n";
     
  for (int i=0;i<numprocs;i++)
  {  
    if (process[i].valid) 
    {
      os << process[i];
    }
  }
	
  Unlock();
  return os;
}

int VSchedConfig::Get(VSchedProcess & entry)
{
  Lock();
  for (int i=0;i<numprocs;i++) { 
    if (process[i].valid && process[i].pid==entry.pid) { 
      entry=process[i];
      Unlock();
      return 0;
    }
  }
  Unlock();
  return -1;
}

int VSchedConfig::GetNValid(VSchedProcess entry[], int n)
{
  Lock();
  int j=0;
  for (int i=0;i<= numprocs && j<n;i++) { 
    if (process[i].valid) { 
      entry[j++]=process[i];
    }
  }
  
  Unlock();
  return j;
}

int VSchedConfig::GetPid(int vpid)
{
	Lock();
  for (int i=0;i< numprocs;i++) { 
    if ((process[i].valid) && (process[i].pid == vpid)) { 
      Unlock();
      return i;
    }
  }
  
  Unlock();
  return -1;
}

bool VSchedConfig::GetPid2(int vpid)
{
	Lock();
  for (int i=0;i< numprocs;i++) { 
    if (process[i].valid && process[i].pid == vpid) { 
      process[i].suspended = true;
      Unlock();
      return true;
    }
  }
  
  Unlock();
  return false;
}

int VSchedConfig::Set(const VSchedProcess & entry)
{
  int firstinvalid=-1;
  Lock();
  // replace if it exists
  for (int i=0;i<numprocs;i++) { 
    if (firstinvalid==-1 && !(process[i].valid)) { 
      firstinvalid=i;
    }
    if (process[i].valid && process[i].pid==entry.pid) { 
      //process[i]=entry;
      process[i].valid=entry.valid;
    	process[i].pid=entry.pid;
	  	process[i].period_ms = entry.period_ms;
	  	process[i].slice_ms = entry.slice_ms;
	  	process[i].left = entry.left;
	  	process[i].next_deadline = entry.next_deadline;
	  	process[i].suspended = entry.suspended;
	  	process[i].run_type = entry.run_type;

      Sort();
      cout << "finish sorting after overwriting" << endl;
      Unlock();
      return 0;
    }
  }
  // create if we have space
  if (firstinvalid==-1) { 
    Unlock();
    // No room
    return -1;
  } else {
    process[firstinvalid].Init();
    //process[firstinvalid]=entry;
    process[firstinvalid].valid=entry.valid;
    process[firstinvalid].pid=entry.pid;
	  process[firstinvalid].period_ms = entry.period_ms;
	  process[firstinvalid].slice_ms = entry.slice_ms;
	  process[firstinvalid].left = entry.left;
	  process[firstinvalid].next_deadline = entry.next_deadline;
	  process[firstinvalid].suspended = entry.suspended;
	  process[firstinvalid].run_type = entry.run_type;

    Sort();
    cout << "finish sorting after inserting" << endl;
    Unlock();
    return 0;
  }
}

void swap(VSchedProcess* a, VSchedProcess* b)
{
	VSchedProcess t;
  
  t.Init();
  t.valid = a->valid;
  t.pid = a->pid;
  t.sched_admit_time = a->sched_admit_time;
  t.period_ms = a->period_ms;
  t.slice_ms = a->slice_ms;
  t.suspended = a->suspended;
  t.run_type = a->run_type;
  t.when_done = a->when_done;
  strncpy(t.pathname, a->pathname, 1024);
  t.next_deadline = a->next_deadline;
  t.left = a->left;
  t.priority = a->priority;
  
  a->valid = b->valid;
  a->pid = b->pid;
  a->sched_admit_time = b->sched_admit_time;
  a->period_ms = b->period_ms;
  a->slice_ms = b->slice_ms;
  a->suspended = b->suspended;
  a->run_type = b->run_type;
  a->when_done = b->when_done;
  strncpy(a->pathname, b->pathname, 1024);
  a->next_deadline = b->next_deadline;
  a->left = b->left;
  a->priority = b->priority;
  
  b->valid = t.valid;
  b->pid = t.pid;
  b->sched_admit_time = t.sched_admit_time;
  b->period_ms = t.period_ms;
  b->slice_ms = t.slice_ms;
  b->suspended = t.suspended;
  b->run_type = t.run_type;
  b->when_done = t.when_done;
  strncpy(b->pathname, t.pathname, 1024);
  b->next_deadline = t.next_deadline;
  b->left = t.left;
  b->priority = t.priority;
  
}

void mysort(VSchedProcess* process, int N)
{
  int i, j;
  VSchedProcess v;

  if(N<=1) return;

  // Partition elements
  v.Init();
  v.next_deadline = process[0].next_deadline;
  i = 0;
  j = N;
  
  for(;;)
  {
    while(process[++i].next_deadline < v.next_deadline && i < N) 
    { 
    }
    
    while(process[--j].next_deadline > v.next_deadline) 
    { 
    }
    
    if(i >= j) break;

    swap(process[i], process[j]);
  }

  swap(process[i-1], process[0]);
  
  mysort(process, i-1);
  mysort(process+i, N-i);
}

void VSchedConfig::Sort()
{
	//Lock();
	mysort(process, numprocs);
	//cout<< "sorting inside the Sort()" <<endl;
	//Unlock();
}

void VSchedProcess::Init()
{
  valid=false;
  pid=0;
  period_ms=0.0;
  slice_ms=0.0;
  suspended = false;
  run_type=FIFO;
  when_done=STOP;
  sched_admit_time=0;
  strcpy(pathname,"NONE");
  next_deadline=2147483648.0; //2^31
  left=0;
  priority=0;
}

ostream & VSchedProcess::Print(ostream &os) 
{
  os << "---"
  	 << "valid="<<valid<<", pid="<<pid<<", period_ms="<<period_ms<<", slice_ms="<<slice_ms
     //<<", sched_admit_time="<<sched_admit_time
     <<", suspended="<<suspended<<", run_type="<< (run_type==FIFO ? "FIFO" : "OTHER") 
     //<<", when_done="<<(when_done==STOP ? "STOP" : "OTHER")<<", pathname="<<pathname
     <<", next_deadline=" << setiosflags(ios::fixed | ios:: showpoint) <<next_deadline<<", left="<<left<<", priority="<<priority;
  os << endl;
  return os;
}

