#include <sys/socket.h>
#include <iostream>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <strings.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <string>
#include <vector>
#include <ncurses.h>
#include <signal.h>

//OpenSSL include libraries
extern "C" {
#define OPENSSL_NO_KRB5
#include <openssl/ssl.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/err.h>
}

using namespace std;

#define VSCHED_PORT 4455

//To obtain encryption details, trun this to 2
#define DETAILS 1 


#define GET(fd,ssl,s) if (GetLine(fd,ssl,s)<0) {close(fd);goto leave_fail2;} 
#define PUT(fd,ssl,s) if (PutLine(fd,ssl,s)!=(int)((s).size())) {goto leave_fail2;}

int main(int argc, char *argv[])
{
  int c;
  extern char *optarg;
  char *host1=0; /* the host the client has to connect to */
  int port1 = VSCHED_PORT; /* the port the client has to connect to */
  int clientfd; /* the client file descriptor */
  struct hostent *hp;
  struct sockaddr_in server_address;
  int MAXLINE = 1024;
  string sendline;
  string command;
  char recvline[MAXLINE], sendline1[MAXLINE];
  string password1, password2, device1, device2;
  string identifier;
  string port2 = "4455";
  char *str;
  int use_ssl = 0;
  int supplied_password1 = 0;
  string first_config; 
  string second_config;
  vector<string> available_addresses;
  
  int pid =0;
  double period = 0.0, slice = 0.0;
  //Initial SSL declarations
  SSL *ssl = NULL;
  SSL_CTX *ssl_ctx = NULL;
  X509 *server_cert;

  SSL_load_error_strings();
  SSLeay_add_ssl_algorithms();

  ssl_ctx = SSL_CTX_new(SSLv2_client_method());
  
  if (argc < 5)
  {
      cerr << "usage: $" << argv[0] << " [-s] [-p password1] [-o port] [-h host] [-c command] [-d pid] [-i period] [-l slice]" << endl
      			<< "command can be one of the following:" 
      			<< endl << "echo" 
      			<< endl << "config" 
      			<< endl << "processes" 
      			<< endl << "done" 
      			<< endl << "schedule <pid> <period> <slice>" 
      			<< endl << "detach <pid>"
      			<< endl << "stop <pid>"
      			<< endl << "resume <pid>"
      			<< endl << endl;
      exit(-1);
  }
  while ((c = getopt(argc, argv, "s p:o:h:c:d:i:l:")) != -1)
  {
      switch(c)
      {
        case 's':
          use_ssl = 1;
          break;
        case 'p':
          supplied_password1 = 1;
          password1 = optarg;
          break;
        case 'o':
          port1 = atoi(optarg);
          break;
        case 'h':
          host1 = optarg;
          break;
        case 'c':
          command = optarg;
          break;
        case 'd':
          pid = atoi(optarg);
          break;
        case 'i':
          period = atof(optarg);
          break;
        case 'l':
          slice = atof(optarg);
          break;           
        case '?':
          cerr << "usage: $" << argv[0] << " [-s] [-p password1] [-o port] [-h host] [-c command] [-d pid] [-i period] [-l slice]" << endl
          		<< "command can be one of the following:" 
      				<< endl << "echo" 
      				<< endl << "config" 
      				<< endl << "processes" 
      				<< endl << "done" 
      				<< endl << "schedule <pid> <period> <slice>" 
      				<< endl << "detach <pid>"
      				<< endl << "stop <pid>"
      				<< endl << "resume <pid>"
      				<< endl << endl;
          exit(-1);
      }
  }//end while
 
  if ( (command != "echo") && (command != "config") && (command != "processes") && (command != "done") && (command != "schedule") && (command != "detach") && (command != "stop") && (command != "resume"))
  {
      cerr << command << " is an invalid command" << endl;
      exit(-1);
  }
  
  if ( (command == "schedule") && ((pid <= 0) || (period <= 0) || (slice <= 0)))
  {
      cerr << command << "Please input valid pid, period, slice for scheduling" << endl;
      exit(-1);
  }
  
  if ( (command == "detach") && (pid <= 0))
  {
      cerr << command << "Please input valid pid for detaching" << endl;
      exit(-1);
  }
  
  if ( (command == "stop") && (pid <= 0))
  {
      cerr << command << "Please input valid pid for stopping" << endl;
      exit(-1);
  }
  
  if ( (command == "resume") && (pid <= 0))
  {
      cerr << command << "Please input valid pid for resuming" << endl;
      exit(-1);
  }
    
  if (supplied_password1 == 0)
  {
      cout << "Please enter password1: ";
      cin >> password1;
  }
  
  /*we will now open up a client socket */
  if ((clientfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
  {
      cerr << "the client descriptor could not be opened" << endl;
      exit(-1);
  }
  
  if ((hp = gethostbyname(host1)) == NULL)
  {
      cerr << "could not locate the host" << endl;
      exit(-1);
  }
  
  /* we will fill up the fields of the server address */
  bzero((char *) &server_address, sizeof(server_address));
  server_address.sin_family = AF_INET;
  server_address.sin_port = htons(port1);
  bcopy((char *) hp->h_addr, (char *) &server_address.sin_addr.s_addr,hp->h_length);

  /*we establish a connection with the server */
  if ((connect (clientfd, (struct sockaddr *)&server_address, sizeof(server_address))) < 0)
  {
      cerr << "the connection could not be established" << endl;
      exit(-1);
  }
  if (use_ssl == 1)
  {
      //We will now get into the SSL negotiation
      ssl = SSL_new(ssl_ctx);
      SSL_set_fd(ssl, clientfd);
      
      //This is where we do the SSL handshake
      int r;
      if ((r = SSL_connect(ssl)) < 0)
      {
          cerr << "SSL connect error" << endl << "r = " << r << endl;
          exit(-1);
      }
      //We next get the encryption algorithm
      if (DETAILS == 2)
        cout << "Connected with the encryption algorithm:" << SSL_get_cipher(ssl) << endl;
      //We next get the server's certificate and print the same to screen
      server_cert = SSL_get_peer_certificate(ssl);
      if (server_cert == NULL)
      {
          if (DETAILS == 2)
            cout << "There are no Vsched certificates" << endl;
      }
      else
      {
          if (DETAILS == 2)
            cout << "VSched Certificate:" << endl;
          str = X509_NAME_oneline(X509_get_subject_name(server_cert),0,0);
          if (DETAILS == 2)
            cout << "    Subject: " << str << endl;
          strcpy(str, "");
          str = X509_NAME_oneline(X509_get_issuer_name(server_cert),0,0);
          if (DETAILS == 2)
            cout << "    Issuer: " << str << endl << endl;
          free(str);
      
          //This is where we can do all the server certificate verification stuff
          //This can be added based on the policy required
      }
      //We now deallocate the server certificate
      X509_free(server_cert);
  }
  
  int count = 0;
  int size = 0;
  sendline = "HELLO_VSCHED "+password1+" 0.9";
  sendline = sendline + "\n";

  if (use_ssl == 1)
  {
      SSL_write(ssl, sendline.c_str(), sendline.size());
      count = SSL_read(ssl, recvline, sizeof(recvline));
  }
  else
  {
      write(clientfd, sendline.c_str(), sendline.size());
      count = read(clientfd, recvline, sizeof(recvline));
  }
    
  
  recvline[count] = '\0';
  cout << "server reply: " << recvline;
  
  if(strncmp(recvline, "SSL", 3) >= 0)
		goto end;

  //start handling commands
			cout << "command: " << command << endl;
			
      if (command == "echo") //echo begin
      {
          cout << "Vsched> ";
          while (fgets(recvline, MAXLINE, stdin) != NULL)
          {
              if (use_ssl == 1)
              {
                  SSL_write(ssl, recvline, strlen(recvline));
                  if ((count = SSL_read(ssl, recvline, sizeof(recvline))) == 0)
                  {
                      return 0;
                  }
              }
              else
              {
                  write(clientfd, recvline, strlen(recvline));
                  if ((count = read(clientfd, recvline, sizeof(recvline))) == 0)
                  {
                      return 0;
                  }
              }
              recvline[count] = '\0';
              cout << recvline;
              if (strcmp(recvline, "OK disconnected\n") == 0)
              {
                  return 0;
              }
              
              cout << "Vsched> ";
          }
       }//echo end
       
       if ((command == "config") || (command == "processes") || (command == "done"))
       {
       		command = command + "\n";
       
          if (use_ssl == 1)
          {
              SSL_write(ssl, command.c_str(), command.size());
              if ((count = SSL_read(ssl, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          else
          {
              write(clientfd, command.c_str(), command.size());
              if ((count = read(clientfd, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          
          recvline[count] = '\0';
          cout << recvline;
              
       }//end
      
       if ((command == "schedule") && (pid > 0) && (period > 0.0) && (slice > 0.0))
       {
       		size = sprintf(sendline1, "%s %d %lf %lf\n", command.c_str(), pid, period, slice);
       		
          if (use_ssl == 1)
          {
              SSL_write(ssl, sendline1, size);
              cout << "send message to server and wait for reply..." << endl;
              if ((count = SSL_read(ssl, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          else
          {
              write(clientfd, sendline1, size);
              cout << "send message to server and wait for reply..." << endl;
              if ((count = read(clientfd, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          
          recvline[count] = '\0';
          cout << recvline;
              
       }//end

       if ((command == "detach") && (pid > 0))
       {
       		size = sprintf(sendline1, "%s %i\n", command.c_str(), pid);
       		
          if (use_ssl == 1)
          {
              SSL_write(ssl, sendline1, size);
              if ((count = SSL_read(ssl, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          else
          {
              write(clientfd, sendline1, size);
              if ((count = read(clientfd, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          
          recvline[count] = '\0';
          cout << recvline;
              
       }//end
       
       if ((command == "stop") && (pid > 0))
       {
       		size = sprintf(sendline1, "%s %i\n", command.c_str(), pid);
       		
          if (use_ssl == 1)
          {
              SSL_write(ssl, sendline1, size);
              if ((count = SSL_read(ssl, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          else
          {
              write(clientfd, sendline1, size);
              if ((count = read(clientfd, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          
          recvline[count] = '\0';
          cout << recvline;
              
       }//end
       
       if ((command == "resume") && (pid > 0))
       {
       		size = sprintf(sendline1, "%s %i\n", command.c_str(), pid);
       		
          if (use_ssl == 1)
          {
              SSL_write(ssl, sendline1, size);
              if ((count = SSL_read(ssl, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          else
          {
              write(clientfd, sendline1, size);
              if ((count = read(clientfd, recvline, MAXLINE)) == 0)
              {
                 return 0;
              }
          }
          
          recvline[count] = '\0';
          cout << recvline;
              
       }//end    

  //end of handling commands
       
  //Close things here and clean up
  sendline = "done";
  sendline = sendline + "\n";
  if (use_ssl == 1)
  {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
  }
  else
  {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
  }
  recvline[count] = '\0';
  cout << recvline;

end:
                  
  if (use_ssl == 1)
    {
      SSL_shutdown(ssl);
      if (ssl != NULL)
        free (ssl);
      if (ssl_ctx != NULL)
        free (ssl_ctx);
    }
  close(clientfd);
  return 0;
}
