#include "admit.h"
#include "math.h"

double U_RM(int num)
{
	return (num * (pow(2.0, (double)(1.0/num)) - 1));
}

// This atomically admits the task if possible
bool AdmitIfPossible(VSchedConfig &config, const VSchedProcess &proc)
{
	double sum = 0.0, u_sum = 0.0; //sum is for schedulability test, u_sum is for schedulable utilization
	int num_proc = 0; //number of valid processes
	bool dp = true;
	
	config.Lock();
	for(int iter = 0; iter <= config.numprocs; iter++)
	{
		if((config.process[iter].valid) && (config.process[iter].pid != proc.pid))
		{
				num_proc++;
				sum = sum + config.process[iter].slice_ms / min(config.process[iter].next_deadline, config.process[iter].period_ms);
				u_sum = u_sum + config.process[iter].slice_ms / config.process[iter].period_ms;
				if(config.process[iter].next_deadline <= config.process[iter].period_ms)
						dp = false;
		}
	}
	
	u_sum = u_sum + proc.slice_ms / proc.period_ms;
	num_proc++;
	
	cout << "current total utilization u_sum = " <<  u_sum << endl;
	
	if (u_sum >= min(U_RM(num_proc), 1.0 - (config.sched_other_percent/100.0)))
	{
		dp = false;	
		cout << "exceed the allowed total utilization" << endl;
	}
	
	sum = sum + proc.left / min(proc.next_deadline, proc.period_ms);
	if(proc.next_deadline <= proc.period_ms)
		dp = false;
						
	config.Unlock();
	cout << "finish the admission compute, sum = " << sum << endl;
	if((sum <= 1.0) && dp)
	{
		return true;
	}
		
	if(!dp)
	{
		//for some process, deadline < period, then the Eq is only a sufficient condition
		//the system may not be schedulable when the condition is not satisfied
		return false;
	}
		
	return false;
}
