#ifndef _raw_ethernet_packet
#define _raw_ethernet_packet
#include <iostream>
#include <stdio.h>
#include "config.h"
extern "C" {
#define OPENSSL_NO_KRB5
#include <openssl/ssl.h>
}

class Packet;

using namespace std;

struct RawEthernetPacket {
  size_t   size;
  char     data[ETHERNET_PACKET_LEN];

  RawEthernetPacket();
  RawEthernetPacket(const RawEthernetPacket &rhs);
  RawEthernetPacket(const char *data, const size_t size);
  const RawEthernetPacket & operator= (const RawEthernetPacket &rhs);
  virtual ~RawEthernetPacket();

  void Serialize(const int fd, SSL *ssl) const;
  void Unserialize(const int fd, SSL *ssl);

  void Print(unsigned size=ETHERNET_PACKET_LEN, FILE *out=stdout) const;
  ostream & Print(ostream &os) const;
};

inline ostream & operator<<(ostream &os, const RawEthernetPacket &p) {
  return p.Print(os);
}
#endif
