#include <malloc.h>
#include <string.h>
#include "raw_ethernet_packet.h"
#include "util.h"

RawEthernetPacket::RawEthernetPacket()
{}


RawEthernetPacket::RawEthernetPacket(const RawEthernetPacket &rhs) 
{
  size=rhs.size;
  memcpy(data,rhs.data,size);
}

RawEthernetPacket::RawEthernetPacket(const char *data, const size_t size)
{
  this->size=size;
  memcpy(this->data,data,size);
}
  

const RawEthernetPacket & RawEthernetPacket::operator= (const RawEthernetPacket &rhs)
{
  size=rhs.size;
  memcpy(data,rhs.data,size);
  return *this;
}


RawEthernetPacket::~RawEthernetPacket() 
{} 



void RawEthernetPacket::Serialize(const int fd, SSL *ssl) const
{
  if (writeall(fd,(char*)&size,sizeof(size),0,1,ssl)!=sizeof(size)) 
    {
      throw SerializationException();
    }
  if (writeall(fd,data,size,0,1,ssl)!=(int)size)
    {
      throw SerializationException();
    }
}


void RawEthernetPacket::Unserialize(const int fd, SSL *ssl) 
{
  if (readall(fd,(char*)&size,sizeof(size),0,1,ssl)!=sizeof(size))
    {
      throw SerializationException();
    }
  if (readall(fd,data,size,0,1,ssl)!=(int)size)
    {
      throw SerializationException();
    }
}



#define MIN(x,y) ((x)<(y) ? (x) : (y))

void RawEthernetPacket::Print(unsigned size, FILE *out) const
{
  fprintf(out,"raw_ethernet_packet: size %-4u first %u bytes: ", this->size, MIN(this->size,size));
  printhexbuffer(out,data,MIN(this->size,size));
  fprintf(out,"\n");
}

ostream & RawEthernetPacket::Print(ostream &os) const
{
  char buf[10240];
  unsigned n;
  unsigned i;

  snprintf(buf,2048,"RawEthernetPacket(size=%u, bytes=", size);
  n=strlen(buf);
  for (i=0;i<size;i++) { 
    bytetohexbyte(data[i],&(buf[n+2*i]));
  }
  buf[n+2*i]=0;
  os<<(char*)buf;
  os<<", text=\"";
  for (i=0;i<size;i++) {
    char c=data[i];
    if (c>=32 && c<=126) { 
      os<<c;
    } else {
      os<<'.';
    }
  }
  os << "\")";

  return os;
}

