#ifndef _handler
#define _handler

#include "util.h"
#include <vector>
#include <string>
#include <openssl/ssl.h>

extern "C" {
#include <libnet.h>
#include <pcap.h>
}

#define LIBNET11 1

const int pcap_proglen=10240;

struct Handler {
  enum ctype {LOCAL,REMOTE} ;
  int    pid;
  int    fd;
  SSL *ssl;
  string local_address;
  short  local_port;
  string local_device;
  string remote_address;
  short  remote_port;
  string remote_device;
  vector<EthernetAddr> addresses;
  ctype local_config;
  ctype remote_config;

  // Internals

  // libnet stuff 
  char net_errbuf[LIBNET_ERRORBUF_SIZE];
#if LIBNET11
  libnet_t *net_interface;
#else
  struct libnet_link_int *net_interface;
#endif
  
  // libpcap stuff
  char pcap_program[pcap_proglen];
  pcap_t *pcap_interface;
  char pcap_errbuf[PCAP_ERRBUF_SIZE];
  struct bpf_program pcap_filter;
  bpf_u_int32 pcap_net, pcap_mask;
  int pcap_fd;
  
  
  
  void Output(string &s) const {
    char buf[1024];
    snprintf(buf,1024,"%d ",pid);
    s=buf;
    s+= (local_config==LOCAL ? "LOCAL " : "REMOTE ");
    s+= local_address;
    s+= " ";
    snprintf(buf,1024,"%u",local_port);
    s+= buf;
    s+= " ";
    s+= local_device;
    s+= " <-> ";
    s+= (remote_config==LOCAL ? "LOCAL " : "REMOTE ");
    s+= remote_address;
    s+= " ";
    snprintf(buf,1024,"%u",remote_port);
    s+= buf;
    s+= " ";
    s+= remote_device;
    for (unsigned i=0;i<addresses.size();i++) {
      s+= " ";
      addresses[i].GetAsString(buf);
      s+= buf;
    }
  }

  void Init();
  void ProcessPcap();
  void ProcessTcp();
  void Run();
  
};


int Handle(Handler &h);

#endif
