#include <unistd.h>
#include <stdio.h>
#include <iostream>
#include <deque>
#include <sys/poll.h>
#include "netinet/if_ether.h"
#include "config.h"
#include "util.h"
#include "raw_ethernet_packet.h"
#include "error.h"
#include "handler.h"



void Handler::Init()
{
 
  
  // establish libnet session
#if LIBNET11
  net_interface=libnet_init(LIBNET_LINK_ADV,(char*) (local_device.c_str()),net_errbuf);
#else
  net_interface=libnet_open_link_interface(local_device.c_str(),net_errbuf);
#endif
  if (net_interface==NULL) { 
    cerr<<"Can't open interface: "<<net_errbuf<<endl;
    exit(-1);
  }

  // establish pcap filter
  if (pcap_lookupnet((char*)(local_device.c_str()),&pcap_net,&pcap_mask,pcap_errbuf)) {
    cerr<<"Can't get net and mask for "<<local_device<<": "<<pcap_errbuf<<endl;
    exit(-1);
  }
  cerr << "pcap_net="<<pcap_net<<", pcap_mask="<<pcap_mask<<endl;
  if ((pcap_interface=pcap_open_live((char*)(local_device.c_str()),1518,1,0,pcap_errbuf))==NULL) { 
    cerr<< "Can't open "<<local_device<<":"<<pcap_errbuf<<endl;
    exit(-1);
  }
  pcap_program[0]=0;
  char dir[5];
  EthernetAddrString addr;
  if (local_config==LOCAL) {
    strcpy(dir,"dst ");
  } else {
    strcpy(dir,"src ");
  }
  if (local_config==LOCAL) {
    (*(addresses.begin())).GetAsString(addr);
    sprintf(pcap_program,"(not ether src %s) and (",addr);
  }
  for (vector<EthernetAddr>::const_iterator i=addresses.begin();
       i!=addresses.end();
       ++i) {
    if (i!=addresses.begin()) {
      strcat(pcap_program," or ");
    } 
    (*i).GetAsString(addr);
    strcat(pcap_program,"ether ");
    strcat(pcap_program,dir);
    strcat(pcap_program,addr);
  }
  if (local_config==LOCAL) {
    strcat(pcap_program,")");
  }
    
  cerr <<"pcap_program='"<<pcap_program<<"'"<<endl;
  if (pcap_compile(pcap_interface,&pcap_filter,pcap_program,0,pcap_mask)) {
    cerr<<"Can't compile filter\n";
    exit(-1);
  }
  if (pcap_setfilter(pcap_interface,&pcap_filter)) { 
    cerr<<"Can't set filter\n";
    exit(-1);
  }
  pcap_fd=pcap_fileno(pcap_interface);

  
}  

void Handler::ProcessPcap()
{
 
  struct pcap_pkthdr header;
  const u_char *packet;

  packet=pcap_next(pcap_interface,&header);

  if (packet==NULL) {
    cerr <<"pcap_next returned a null pointer\n";
    exit(-1);
  }

  RawEthernetPacket p((const char *)packet,(unsigned)(header.len));
  p.Serialize(fd,ssl);
 
}


void Handler::ProcessTcp()
{
  
  RawEthernetPacket p;

  p.Unserialize(fd,ssl);
  
#if LIBNET11
  if (libnet_adv_write_link(net_interface,
                            (u_char *)(p.data),
                            p.size)<0) {
#else
    if (libnet_write_link_layer(net_interface,
                                (const char *)device,
                                (u_char *)(p.data),
                                p.size)<0) {
#endif
      cerr << "Can't write output packet to link\n";
      exit(-1);
    }
  
  }

  

#define MAX(x,y) ((x)>(y) ? (x) : (y))


  void Handler::Run()
    {
      fd_set fds;
  
      while (1) {
        FD_ZERO(&fds);
        FD_SET(pcap_fd,&fds);
        FD_SET(fd,&fds);
        int rc=select(MAX(pcap_fd,fd)+1,&fds,0,0,0);
        if (rc<0) {
          if (errno==EINTR) {
            // shouldn't happen on linux, but can happen on solaris
            continue;
          }
        } else if (rc==0) {
          // huh? didn't ask for timeouts so just repeat
          continue;
        } else {
          if (FD_ISSET(fd,&fds)) {
            ProcessTcp();
          } 
          if (FD_ISSET(pcap_fd,&fds)) {
            ProcessPcap();
          }
        }
      }
    }

  int Handle(Handler &h)
    {

      h.Init();
      h.Run();
      return 0;
    }
