#include <sys/socket.h>
#include <iostream>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <strings.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <string>
#include <vector>
#include <ncurses.h>
#include <signal.h>

//OpenSSL include libraries
extern "C" {
#define OPENSSL_NO_KRB5
#include <openssl/ssl.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/err.h>
}

using namespace std;

#define VNET_PORT 4455

//To obtain encryption details, trun this to 2
#define DETAILS 1 

int main(int argc, char *argv[])
{
  int c;
  extern int optind;
  extern char *optarg;
  char *host1=0; /* the host the client has to connect to */
  int port1 = VNET_PORT; /* the port the client has to connect to */
  int clientfd; /* the client file descriptor */
  struct hostent *hp;
  struct sockaddr_in server_address;
  int MAXLINE = 1024;
  string sendline;
  string command;
  char recvline[MAXLINE];
  string password1, password2, device1, device2;
  string identifier;
  char *host2=0;
  string port2 = "4455";
  char *str;
  int use_ssl = 0;
  int supplied_password1 = 0;
  int supplied_password2 = 0;
  int supplied_pid = 0;  
  string first_config; 
  string second_config;
  vector<string> available_addresses;
  vector<string>::iterator i;
  
  //Initial SSL declarations
  SSL *ssl = NULL;
  SSL_CTX *ssl_ctx = NULL;
  X509 *server_cert;

  SSL_load_error_strings();
  SSLeay_add_ssl_algorithms();

  ssl_ctx = SSL_CTX_new(SSLv2_client_method());
  
  if (argc < 5)
    {
      cerr << "usage: $" << argv[0] << " [-s] [-p password1] [-o port1] -h <host1> -c <command>" << endl << endl << "command can be one of the following:" << endl << "echo" << endl << "handlers" << endl << "devices" << endl << "close -i <pid>" << endl << "handle [-a port2] [-b password2] -d <host2> -e <device1> -f <device2> -g <first config local|remote> -j <addresses+>\nThe first address specified should not be the broadcast or multicast address, it should always follow the MAC address for an interface" << endl << endl;
      exit(-1);
    }
  while ((c = getopt(argc, argv, "s h:p:o:c:i:a:b:d:e:f:g:j:")) != -1)
    {
      switch(c)
        {
        case 's':
          use_ssl = 1;
          break;
        case 'h':
          host1 = optarg;
          break;
        case 'p':
          supplied_password1 = 1;
          password1 = optarg;
          break;
        case 'o':
          port1 = atoi(optarg);
          break;
        case 'c':
          command = optarg;
          break;
        case 'i':
          identifier = optarg;
          supplied_pid = 1;
          break;
        case 'a':
          port2 = optarg;
          break;
        case 'b':
          supplied_password2 = 1;
          password2 = optarg;
          break;
        case 'd':
          host2 = optarg;
          break;
        case 'e':
          device1 = optarg;
          break;
        case 'f':
          device2 = optarg;
          break;
        case 'g':
          first_config = optarg;
          if (first_config == "local")
            {
              first_config = "LOCAL";
              second_config = "REMOTE";
            }
          else if (first_config == "remote")
            {
              first_config = "REMOTE";
              second_config = "LOCAL";
            }
          else
            {
              cerr << "1usage: $" << argv[0] << " [-s] [-p password1] [-o port1] -h <host1> -c <command>" << endl << endl << "command can be one of the following:" << endl << "echo" << endl << "handlers" << endl << "devices" << endl << "close -i <pid>" << endl << "handle [-a port2] [-b password2] -d <host2> -e <device1> -f <device2> -g <first config local|remote> -j <addresses+>\nThe first address specified should not be the broadcast or multicast address, it should always follow the MAC address for an interface" << endl << endl;
              exit(-1);
            }
          break;
        case 'j':
          if ((strcmp(optarg, "ff:ff:ff:ff:ff:ff") == 0) ||(strcmp(optarg, "FF:FF:FF:FF:FF:FF")==0))
            {
              cerr << "The first address specified should NOT be the broadcast or multicast address, it should always follow a MAC address for an interface\n\n";
              cerr << "1usage: $" << argv[0] << " [-s] [-p password1] [-o port1] -h <host1> -c <command>" << endl << endl << "command can be one of the following:" << endl << "echo" << endl << "handlers" << endl << "devices" << endl << "close -i <pid>" << endl << "handle [-a port2] [-b password2] -d <host2> -e <device1> -f <device2> -g <first config local|remote> -j <addresses+>\nThe first address specified should not be the broadcast or multicast address, it should always follow the MAC address for an interface " << endl << endl;
              exit(-1);
            }
          available_addresses.push_back(string(optarg));
          for(; optind < argc; optind++)
            {
              available_addresses.push_back(argv[optind]);
              
            }
          break;
          
        case '?':
          cerr << "2usage: $" << argv[0] << " [-s] [-p password1] [-o port1] -h <host1> -c <command>" << endl << endl << "command can be one of the following:" << endl << "echo" << endl << "handlers" << endl << "devices" << endl << "close -i <pid>" << endl << "handle [-a port2] [-b password2] -d <host2> -e <device1> -f <device2> -g <first config local|remote> -j <addresses+>\nThe first address specified should not be the broadcast or multicast address, it should always follow the MAC address for an interface" << endl << endl;
          exit(-1);
        }
    }
  if ((command == "close") && (supplied_pid == 0))
    {
      cerr << "3usage: $" << argv[0] << " [-s] [-p password1] [-o port1] -h <host1> -c <command>" << endl << endl << "command can be one of the following:" << endl << "echo" << endl << "handlers" << endl << "devices" << endl << "close -i <pid>" << endl << "handle [-a port2] [-b password2] -d <host2> -e <device1> -f <device2> -g <first config local|remote> -j <addresses+>\nThe first address specified should not be the broadcast or multicast address, it should always follow the MAC address for an interface" << endl << endl;

      exit(-1);
    }

 
  if ( (command != "echo") && (command != "devices") && (command != "handlers") && (command != "close") && (command != "handle"))
    {
      cerr << command << " is an invalid command" << endl;
      exit(-1);
    }
  
  if (supplied_password1 == 0)
    {
      cout << "Please enter password1: ";
      cin >> password1;
    }
  
  if (command == "handle")
    {

      if (argc < 16)
        {
          cerr << "usage: $" << argv[0] << " [-s] [-p password1] [-o port1] -h <host1> -c <command>" << endl << endl << "command can be one of the following:" << endl << "echo" << endl << "handlers" << endl << "devices" << endl << "close -i <pid>" << endl << "handle [-a port2] [-b password2] -d <host2> -e <device1> -f <device2> -g <first config local|remote> -j <addresses+>" << endl << endl;
          exit(-1);
        }
      
      if (supplied_password2 == 0)
        {
          cout << "Please enter password2: ";
          cin >> password2;
          
        }
    }
  
  /*we will now open up a client socket */
  if ((clientfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      cerr << "the client descriptor could not be opened" << endl;
      exit(-1);
    }
  if ((hp = gethostbyname(host1)) == NULL)
    {
      cerr << "could not locate the host" << endl;
      exit(-1);
    }
  
  /* we will fill up the fields of the server address */
  bzero((char *) &server_address, sizeof(server_address));
  server_address.sin_family = AF_INET;
  server_address.sin_port = htons(port1);
  bcopy((char *) hp->h_addr, (char *) &server_address.sin_addr.s_addr,hp->h_length);

  /*we establish a connection with the server */
  if ((connect (clientfd, (struct sockaddr *)&server_address, sizeof(server_address))) < 0)
    {
      cerr << "the connection could not be established" << endl;
      exit(-1);
    }
  if (use_ssl == 1)
    {
      //We will now get into the SSL negotiation
      ssl = SSL_new(ssl_ctx);
      SSL_set_fd(ssl, clientfd);
      
      //This is where we do the SSL handshake
      int r;
      if ((r = SSL_connect(ssl)) < 0)
        {
          cerr << "SSL connect error" << endl << "r = " << r << endl;
          exit(-1);
        }
      //We next get the encryption algorithm
      if (DETAILS == 2)
        cout << "Connected with the encryption algorithm:" << SSL_get_cipher(ssl) << endl;
      //We next get the server's certificate and print the same to screen
      server_cert = SSL_get_peer_certificate(ssl);
      if (server_cert == NULL)
        {
          if (DETAILS == 2)
            cout << "There are no VNET certificates" << endl;
        }
      else
        {
          if (DETAILS == 2)
            cout << "VNET Certificate:" << endl;
          str = X509_NAME_oneline(X509_get_subject_name(server_cert),0,0);
          if (DETAILS == 2)
            cout << "    Subject: " << str << endl;
          strcpy(str, "");
          str = X509_NAME_oneline(X509_get_issuer_name(server_cert),0,0);
          if (DETAILS == 2)
            cout << "    Issuer: " << str << endl << endl;
          free(str);
      
          //This is where we can do all the server certificate verification stuff
          //This can be added based on the policy required
        }
      //We now deallocate the server certificate
      X509_free(server_cert);
    }
  int count;
  sendline = "HELLO "+password1+" 1.0";
  sendline = sendline + "\n";

  if (use_ssl == 1)
    {
      SSL_write(ssl, sendline.c_str(), sendline.size());
      count = SSL_read(ssl, recvline, MAXLINE);
    }
  else
    {
      write(clientfd, sendline.c_str(), sendline.size());
      count = read(clientfd, recvline, MAXLINE);
    }
  recvline[count] = '\0';
  if (recvline[0] != 'O')
    {
      cout << recvline << endl;
      exit(-1);
    }
  else
    {
      if (command == "echo") //echo begin
        {
          fgets(recvline, MAXLINE, stdin);
          while (fgets(recvline, MAXLINE, stdin) != NULL)
            {
              if (use_ssl == 1)
                {
                  SSL_write(ssl, recvline, strlen(recvline));
                  if ((count = SSL_read(ssl, recvline, MAXLINE)) == 0)
                    {
                      return 0;
                    }
                }
              else
                {
                  write(clientfd, recvline, strlen(recvline));
                  if ((count = read(clientfd, recvline, MAXLINE)) == 0)
                    {
                      return 0;
                    }
                }
              recvline[count] = '\0';
              cout << recvline;
              if (strcmp(recvline, "OK disconnected\n") == 0)
                {
                  return 0;
                }
            }
        }//echo end

      if (command == "devices") //devices begin
        {
          sendline = "DEVICES?";
          sendline = sendline + "\n";
          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          sendline = "DONE";
          sendline = sendline + "\n";
          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          return 0;           
        }//devices end

      if (command == "handlers") //handlers begin
        {
          sendline = "HANDLERS?";
          sendline = sendline + "\n";
          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          sendline = "DONE";
          sendline = sendline + "\n";
          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          return 0;           
        }//handlers end
      if (command == "close") //close begin
        {
          sendline = "CLOSE " + identifier;
          sendline = sendline + "\n";
          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          sendline = "DONE";
          sendline = sendline + "\n";
          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          return 0;           
        }//close end
      if (command == "handle") //handle begin
        {
          sendline = "HANDLE "+password2+" "+first_config+" "+device1+" "+second_config+" "+host2+" "+port2+" "+device2+" ";
          for (i=available_addresses.begin(); i!=available_addresses.end(); ++i)
            {
              sendline = sendline + *i + " ";
            }
          sendline = sendline + "\n";

          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
           
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          sendline = "DONE";
          sendline = sendline + "\n";
          if (use_ssl == 1)
            {
              SSL_write(ssl, sendline.c_str(), sendline.size());
              count = SSL_read(ssl, recvline, MAXLINE);
            }
          else
            {
              write(clientfd, sendline.c_str(), sendline.size());
              count = read(clientfd, recvline, MAXLINE);
            }
          recvline[count] = '\0';
          cout << recvline;
          return 0;           
        }//handle end
    }
       
  //Close things here and clean up
  if (use_ssl == 1)
    {
      SSL_shutdown(ssl);
      if (ssl != NULL)
        free (ssl);
      if (ssl_ctx != NULL)
        free (ssl_ctx);
    }
  close(clientfd);
  return 0;
}
