#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <curses.h>
#include <panel.h>
//#include <form.h>

#include "ipdrecv_ctrl.h"

#define LDAVGC_FILENAME "ldavgc"

#ifndef CTRL
#define CTRL(x)		((x) & 0x1f)
#endif


typedef struct gdefs_t {
	int interval;
	message_type transport;	
} gdefs_t;

typedef struct ctrl {
//	PANEL * panel;
//	FORM * form;

	char * filename;
	int netmask;
	long address;
	message_type transport;
	struct ctrl * next;
	struct ctrl * prev;
} ctrl;

typedef struct host_t {
	long address;
	double loadavg;
	int age;

	struct host_t * next;
	struct host_t * prev;
} host_t;


int gnum_hosts = 0;
WINDOW * mainwin;


void help();

void start_win();
void drawwin();
char * add_host_setup();
int del_host_setup();
int delete_ctrl(int ctrl_index);
void delete_listeners();

void age_hosts(host_t * host_list);
int update_hosts(host_t * host_list, message_t msg, message_type transport);
void create_new_host(message_t msg, message_type transport);
int add_host(char * address);
void update_averages();
void sort_hosts();
void clear_hosts(long address, int netmask);
void delete_host(host_t * host);

int check_valid_ip(char * address);
__u32 addr_char_to_u32(char * address);
int ipcmp(long address, int netmask, long address2);
