#include "ipdrecv_ctrl.h"


typedef struct debug_record_t {
	char * address;
	int netmask;
	message_type type;
	char * filename;
	int clear;
	
	int used;

} debug_record_t;


int num_records = 0;
debug_record_t records[256];


int ipd_add_receiver(const char * address, int netmask, message_type type, char * filename, int clear) {
	records[num_records].address = (char *)malloc(strlen(address) + 1);
	strcpy(records[num_records].address, address);
	records[num_records].netmask = netmask;
	records[num_records].type = type;
	records[num_records].filename = (char *)malloc(strlen(filename)+1);
	strcpy(records[num_records].filename, filename);
	records[num_records].clear = clear;
	records[num_records].used = 1;

	num_records++;
return 0;
}



int ipd_delete_receiver(char * filename) {
	int i=0;

	for (i = 0; i < num_records; i++) {
	}

return 0;
} 



__u32 generate_rand_address(char * address, int netmask) {
	char * c_addr = (char * )malloc(strlen(address)+1);
	__u32 saddr;
	__u32 mask, lowmask;
	char * holder;
	int lowbits;

	strcpy(c_addr, address);

	saddr = 0;
        saddr += atoi(strsep(&c_addr, ".")) << 24;
        saddr = saddr >> 8;
        saddr += atoi(strsep(&c_addr, ".")) << 24;
        saddr = saddr >> 8;
        saddr += atoi(strsep(&c_addr, ".")) << 24;
        saddr = saddr >> 8;
        saddr += atoi(c_addr) << 24;

	mask = 0xffffffff;
	mask = mask >> (32 - netmask);
	saddr = mask & saddr;
	lowmask = mask ^ 0xffffffff;	

	lowbits = rand();

	lowbits = lowbits & lowmask;
//	printf("%x - %x\n", lowbits, saddr);

	saddr = saddr | lowbits;

//	printf("%x\n", saddr);
	return saddr;
}

__u16 generate_rand_ldavg() {
	int avg = rand() % 1000;
	return (__u16)avg;
}

message_queue_t * generate_random_message(debug_record_t * record) {
	message_queue_t * msg_q = (message_queue_t*)malloc(sizeof(message_queue_t));
	__u16 avg;

	if (record->type == ARP) {
		arp_message_t * arp_msg = (arp_message_t*)malloc(sizeof(arp_message_t));
		arp_msg->saddr = generate_rand_address(record->address, record->netmask);
		arp_msg->daddr = arp_msg->saddr;
		avg = generate_rand_ldavg();
		arp_msg->message[1] = (avg & 0xff00) >> 8;
		arp_msg->message[0] = avg & 0x00ff;

		msg_q->msg.arp_msg = arp_msg;
	} else if (record->type == TCP_URGENT) {
		tcp_message_t * tcp_msg = (tcp_message_t*)malloc(sizeof(tcp_message_t));
		tcp_msg->saddr = generate_rand_address(record->address, record->netmask);
		tcp_msg->srcport = rand();
		tcp_msg->dstport = rand();
		tcp_msg->daddr = tcp_msg->saddr;
		avg = generate_rand_ldavg();
//		printf("%x\n", avg);
		tcp_msg->message[1] = (avg & 0xff00) >> 8;
		tcp_msg->message[0] = avg & 0x00ff;
		tcp_msg->flag = 15;

		msg_q->msg.tcp_msg= tcp_msg;
	} else if (record->type = IP_DFRAG) {
		ip_message_t * ip_msg = (ip_message_t *)malloc(sizeof(ip_message_t));
		ip_msg->saddr = generate_rand_address(record->address, record->netmask);
		ip_msg->daddr = ip_msg->saddr;
		avg = generate_rand_ldavg();

		ip_msg->message[1] = (avg & 0xff00) >> 8;
		ip_msg->message[0] = avg & 0x00ff;
		ip_msg->flag = 1;

		msg_q->msg.ip_msg = ip_msg;
	}
	return msg_q;
}



ipd_receiver_t * retrieve_messages(char * filename) {
	int i=0, x=0;
	ipd_receiver_t * recv = NULL;
	int num_msgs;
	time_t tm;

	srand(time(&tm));

	num_msgs = rand() % 100;
	for (i = 0; i < num_records; i++) {
		if (strcmp(filename, records[i].filename) == 0) {
			recv = (ipd_receiver_t *)malloc(sizeof(ipd_receiver_t));
			recv->filename = malloc(strlen(filename)+1);
			strcpy(recv->filename, filename);

			recv->type = records[i].type;
			recv->num_msgs = num_msgs;
			for (x = 0; x < num_msgs; x++) {
				message_queue_t * msg_q = generate_random_message(&records[i]);
				msg_q->next = NULL;
				msg_q->prev = NULL;
				if (x==0) {
					recv->msg_queue = msg_q;
					recv->msg_queue_tail = msg_q;
				} else {
					recv->msg_queue_tail->next = msg_q;
					msg_q->prev = recv->msg_queue_tail;
					recv->msg_queue_tail = msg_q;
				}
			}
		}
	}
	return recv;
}





#ifdef TEST

int main(int argc, char ** argv) {
	__u32 addr;
	ipd_receiver_t * recv;

	addr = generate_rand_address("192.168.1.102", 24);

                printf("Addr: %u.%u.%u.%u\n",
                        (addr & 0x000000ff),
                        (addr & 0x0000ff00) >> 8,
                        (addr & 0x00ff0000) >> 16,
                        (addr & 0xff000000) >> 24);

	printf("Adding receiver...");
	ipd_add_receiver("192.168.1.102", 24, TCP_URGENT, "foo", 1);
	printf("ok.\n");

while (1) {
	printf("getting random messages...");
	recv = retrieve_messages("foo");
	printf("ok.\nMessages retrieved: %d\n", recv->num_msgs);
	if (recv != NULL) {
		int i = 0;
		message_queue_t * msg_q = recv->msg_queue;
		for (i = 0; i < recv->num_msgs; i++) {
			if (recv->type == TCP_URGENT) {
				int avg = msg_q->msg.tcp_msg->message[0];
				avg = avg << 8;
				printf("%x%x -- %u.%u.%u.%u\n", msg_q->msg.tcp_msg->message[0], msg_q->msg.tcp_msg->message[1],\
					(msg_q->msg.tcp_msg->saddr & 0x000000ff),
					(msg_q->msg.tcp_msg->saddr & 0x0000ff00) >> 8,
					(msg_q->msg.tcp_msg->saddr & 0x00ff0000) >> 16,
					(msg_q->msg.tcp_msg->saddr & 0xff000000) >> 24);

				msg_q = msg_q->next;
			}

		}
	}
	sleep(5);
}
return 0;
}

#endif

