#define LDAV_UPTIME_EXEC "/usr/bin/uptime"

#include "getloadavg.h"
#include <sys/types.h>
#include <sys/param.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

#define LOAD_AVE_TYPE double
#include <fcntl.h>

#ifndef errno
extern int errno;
#endif

#include <libelf/nlist.h>

int RPSgetloadavg (double loadavg[], int nelem)
{
  double ldav[3];
  int pipes[2];
  int pid;
  char buf[1024];
  int len,i ;
  int nr;

  if (pipe(pipes)) { 
    return -1;
  }

  pid = fork();
  if (pid) {
    close(pipes[1]);
    len=0;
    nr=1;
    while (len<1024 && nr!=0) { 
      nr = read(pipes[0],&(buf[len]),1024-len);
      if (nr<0) { 
        close(pipes[0]);
	return -1;
      }
      len+=nr;
    }
    close(pipes[0]);
    if (len<0) { 
      return -1;
    }
    buf[len==1024 ? len-1 : len]=0;
    for (i=len-1;i>=0 && buf[i]!=':';i--) { 
    }
    
    nr=sscanf(&buf[i+1],"%lf, %lf, %lf",&(ldav[0]),&(ldav[1]),&(ldav[2]));
    for (i=0;i<nelem;i++) {
      loadavg[i]=ldav[i];
    }

    wait(NULL);
    return nelem < nr ? nelem : nr ;
  } else {
    close(pipes[0]);
    dup2(pipes[1],fileno(stdout)); 
    execl(LDAV_UPTIME_EXEC,LDAV_UPTIME_EXEC,0);
    close(pipes[1]);
    fprintf(stderr,"Could not execl uptime!\n");
    exit(-1);
  }
}




#ifdef TEST
int main (int argc, char **argv)
{
  int naptime = 0;

  if (argc > 1)
    naptime = atoi (argv[1]);

  while (1)
    {
      double avg[3];
      int loads;

      errno = 0;		/* Don't be misled if it doesn't set errno.  */
      loads = RPSgetloadavg (avg, 3);
      if (loads == -1)
	{
	  perror ("Error getting load average");
	  exit (1);
	}
      if (loads > 0)
	printf ("1-minute: %f  ", avg[0]);
      if (loads > 1)
	printf ("5-minute: %f  ", avg[1]);
      if (loads > 2)
	printf ("15-minute: %f  ", avg[2]);
      if (loads > 0)
	putchar ('\n');

      if (naptime == 0)
	break;
      sleep (naptime);
    }

  exit (0);
}
#endif
