#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <linux/types.h>
#include <unistd.h>
#include <fcntl.h>

#define PROCFILE "/proc/ipdsend"

typedef struct {
	char	message[2];
	unsigned char	flagip:1,
			flagstcp:4,
			unused:3;
} iptcpdata;

typedef struct {
	__u32 ipaddr;
	unsigned char mask;
	char repeat;
	char priority;
	iptcpdata data;
	char	useip:1,
		usetcp:1,
		unused:6;
} iptcpentry;

typedef struct iptcplistentry {
	iptcpentry* entry;
	struct iptcplistentry* next;
} iptcplistentry;

typedef struct {
	char length;
	char message[60];
} arpethdata;

typedef struct {
	char macaddr[6];
	unsigned char mask;
	char repeat;
	char priority;
	__u16 protocol;
	arpethdata data;
} ethentry;

typedef struct ethlistentry {
	ethentry* entry;
	struct ethlistentry* next;
} ethlistentry;

iptcpentry* ipd_create_iptcp_entry(char* ipaddr, char mask, char repeat, char priority, iptcpdata data, int useip, int usetcp);
int ipd_enqueue_iptcp(iptcpentry* entry);
int ipd_enqueue_iptcp_list(iptcplistentry* head);
int ipd_clear_iptcp();
int ipd_clear_ip();
int ipd_clear_tcp();
int ipd_iptcp_queue_length();
iptcplistentry* ipd_iptcp_read_queue();
void ipd_iptcp_free_list(iptcplistentry* head);

int ipd_set_arp_send(arpethdata data);
int ipd_clear_arp();
arpethdata* ipd_read_arp_send();

ethentry* ipd_create_eth_entry(char* macaddr, char mask, char repeat, char priority, __u16 protocol, arpethdata data);
int ipd_enqueue_eth(ethentry* entry);
int ipd_enqueue_eth_list(ethlistentry* head);
int ipd_clear_eth();
int ipd_eth_queue_length();
ethlistentry* ipd_eth_read_queue();
void ipd_eth_free_list(ethlistentry* head);

