#include "ipdsend_ctrl.h"

#ifdef TEST

int main(int argc, char** argv) {
	iptcpentry* ipentry;
	iptcpdata ipdata;
	iptcplistentry* iplist;
	ethentry* eentry;
	arpethdata edata;
	ethlistentry* elist;
	arpethdata* arpdata;

	ipdata.message[0] = '.';
	ipdata.message[1] = 'c';
	ipdata.flagip = 1;
	ipdata.flagstcp = 10;
	ipentry = ipd_create_iptcp_entry("127.0.0.1", 32, -1, 0, ipdata, 1, 0);
	if (ipentry == NULL) {
		printf("ipd_create_iptcp_entry failed\n");
		return -1;
	}
	strcpy(edata.message, "Testing Send Control");
	edata.length = strlen(edata.message);
	eentry = ipd_create_eth_entry("00:59:CB:4D:A3:FF", 0, -1, 0, 22745, edata);
	if (eentry == NULL) {
		printf("ipd_create_eth_entry failed\n");
		return -11;
	}
	if (ipd_enqueue_iptcp(ipentry) < 0) {
		printf("ipd_enqueue_iptcp failed\n");
		return -2;
	}
	if (ipd_enqueue_eth(eentry) < 0) {
		printf("ipd_enqueue_eth failed\n");
		return -12;
	}
	if (ipd_set_arp_send(edata) < 0) {
		printf("ipd_set_arp_send failed\n");
		return -22;
	}
	ipentry->usetcp = 1;
	ipentry->priority = 10;
	ipentry->data.message[0] = 's';
	ipentry->data.message[1] = 'm';
	if (ipd_enqueue_iptcp(ipentry) < 0)
		return -3;
	eentry->priority = 10;
	eentry->data.length = 7;
	if (ipd_enqueue_eth(eentry) < 0)
		return -13;
	ipentry->useip = 0;
	ipentry->priority = -1;
	ipentry->repeat = 100;
	ipentry->mask = 24;
	ipentry->data.message[0] = 'C';
	ipentry->data.message[1] = 'l';
	if (ipd_enqueue_iptcp(ipentry) < 0)
		return -4;
	eentry->priority = -1;
	eentry->mask = 24;
	eentry->repeat = 100;
	eentry->protocol = 12345;
	strcpy(eentry->data.message, "further testing");
	if (ipd_enqueue_eth(eentry) < 0)
		return -14;
	free(ipentry);
	free(eentry);
	printf("Queued entries\n");
	getchar();

	iplist = ipd_iptcp_read_queue();
	if (iplist == NULL) {
		printf("Error reading queue\n");
		return -5;
	}
	elist = ipd_eth_read_queue();
	if (elist == NULL) {
		printf("Error reading eth queue\n");
		return -15;
	}
	arpdata = ipd_read_arp_send();
	if (arpdata == NULL) {
		printf("Error reading arp data\n");
		return -25;
	}
	if (ipd_enqueue_iptcp_list(iplist) < 0) {
		printf("Error enqueuing list\n");
		return -6;
	}
	if (ipd_enqueue_eth_list(elist) < 0) {
		printf("Error enqueuing eth list\n");
		return -16;
	}
	if (ipd_clear_arp() < 0) {
		printf("Error clearing arp\n");
		return -27;
	}
	if (ipd_set_arp_send(*arpdata) < 0) {
		printf("Error enqueuing read arp data\n");
		return -26;
	}
	ipd_iptcp_free_list(iplist);
	ipd_eth_free_list(elist);
	free(arpdata);
	printf("Doubled list\n");
	getchar();

	if (ipd_clear_iptcp() < 0) {
		printf("Error clearing queue\n");
		return -7;
	}
	if (ipd_clear_eth() < 0) {
		printf("Error clearing eth queue\n");
		return -17;
	}
	if (ipd_clear_arp() < 0) {
		printf("Error clearing arp data\n");
		return -27;
	}
	printf("Cleared list\n");
	getchar();

	return 0;
}

#endif

int write_all(int fd, char* buf, int len) {
	int n, left;
	left = len;
	while (left > 0) {
		n = write(fd,&(buf[len-left]),left);
		if (n < 0)
			return -1;
		left -= n;
	}
	return 0;
}

int write_proc(char* buf, int len) {
	int fd, ret;
	if ((fd = open(PROCFILE, O_WRONLY)) < 0)
		return fd;
	if ((ret = write_all(fd, buf, len)) < 0)
		return ret;
	close(fd);
	return 0;
}

int open_proc() {
	return open(PROCFILE, O_RDONLY);
}

char* read_until_string(int file, char* terminate) {
	int curbufsize = 8;
	int len = 0;
	int termpos = 0;
	char* readdata = malloc(8 * sizeof(char));
	if (readdata == NULL)
		return NULL;
	while (read(file, readdata + len++, 1) > 0) {
		readdata[len] = '\0';
		if (strstr(readdata, terminate))
			return readdata;
		if (len + 1 >= curbufsize) {
			curbufsize += 8;
			readdata = realloc(readdata, curbufsize * sizeof(char));
			if (readdata == NULL)
				return NULL;
		}
	}
	free(readdata);
	return NULL;
}

char* read_size(int file, int len) {
	int curlen = 0;
	int readlen = 0;
	char* readdata = malloc((len + 1) * sizeof(char));
	if (readdata == NULL)
		return NULL;

	while ((readlen = read(file, readdata + curlen, len - curlen)) > 0)
		if ((curlen += readlen) >= len)
			return readdata;

	free(readdata);
	return NULL;
}

__u32 parse_dotted_addr(char* addr) {
	__u32 newaddr = 0;
	char* part;
	char* begin = malloc(strlen(addr) + 1);
	char* rest = begin;
	if (begin == NULL)
		return 0;
	strcpy(rest, addr);
	part = strsep(&rest, ".");
	newaddr += atoi(part);
	part = strsep(&rest, ".");
	newaddr += 256 * atoi(part);
	part = strsep(&rest, ".");
	newaddr += 65536 * atoi(part);
	newaddr += 16777216 * atoi(rest);
	free(begin);
	return newaddr;
}

int check_dotted_addr(char* addr) {
	int val;
	char* part;
	char* begin = malloc(strlen(addr) + 1);
	char* rest = begin;
	int i;
	if (begin == NULL)
		return -1;
	strcpy(rest, addr);
	for (i = 0; i < 3; i++) {
		part = strsep(&rest, ".");

		val = atoi(part);
		if (val < 0 || val > 255) {
			free(begin);
			return -1;
		}
	}
	val = atoi(rest);
	if (val < 0 || val > 255) {
		free(begin);
		return -1;
	}
	free(begin);
	return 0;
}

int strip_hex_nibble(char** string) {
	char nibble;
	if (strlen(*string) <= 0)
		return -1;
	nibble = (*string)[0];
	(*string)++;
	if (nibble >= 48 && nibble < 58)
		return nibble - 48;
	if (nibble > 64 && nibble <= 70)
		return nibble - 55;
	if (nibble > 96 && nibble <= 102)
		return nibble - 87;
	return -1;
}

int check_mac_addr(char* addr) {
	char* working = addr;
	int i;
	for (i = 0; i < 5; i++) {
		if (strip_hex_nibble(&working) < 0 || strip_hex_nibble(&working) < 0)
			return -1;
		if (working[0] != ':')
			return -1;
		working++;
	}
	if (strip_hex_nibble(&working) < 0 || strip_hex_nibble(&working) < 0)
		return -1;
	if (strlen(working) > 0)
		return -1;
	return 0;
}

char* parse_mac_addr(char* addr) {
	int nibble1, nibble2;
	char* working = addr;
	char* newaddr = malloc(7 * sizeof(char));
	char* current = newaddr;
	int i;
	if (newaddr == NULL)
		return NULL;
	for (i = 0; i < 6; i++) {
		nibble1 = strip_hex_nibble(&working);
		nibble2 = strip_hex_nibble(&working);
		current[0] = (char)(16 * nibble1 + nibble2);
		current++;
		working++;
	}
	return newaddr;
}

iptcpentry* ipd_create_iptcp_entry(char* ipaddr, char mask, char repeat, char priority, iptcpdata data, int useip, int usetcp) {
	iptcpentry* entry;

	if (check_dotted_addr(ipaddr) < 0)
		return NULL;
	if (mask > 32 || mask < 0)
		return NULL;
	entry = malloc(sizeof(iptcpentry));
	if (entry == NULL)
		return NULL;

	entry->ipaddr = parse_dotted_addr(ipaddr);
	entry->mask = (unsigned char)mask;
	entry->repeat = repeat;
	entry->priority = priority;
	entry->data = data;
	if (useip) {
		entry->useip = 1;
	}
	if (usetcp) {
		entry->usetcp = 1;
	}
	return entry;
}

int ipd_enqueue_iptcp(iptcpentry* entry) {
	char buffer[11];

	buffer[0] = 0;
	if (entry->useip)
		buffer[0] += 1;
	if (entry->usetcp)
		buffer[0] += 2;
	memcpy(&(buffer[1]), &(entry->ipaddr), 4);
	if (entry->mask > 32)
		return -1;
	buffer[5] = (char)(entry->mask);
	buffer[6] = entry->repeat;
	buffer[7] = entry->priority;
	buffer[8] = entry->data.message[0];
	buffer[9] = entry->data.message[1];
	buffer[10] = 0;
	buffer[10] += 16 * entry->data.flagip;
	buffer[10] += entry->data.flagstcp;

	return write_proc(buffer, 11);
}

int ipd_enqueue_iptcp_list(iptcplistentry* head) {
	iptcplistentry* current = head;
	int ret;
	while (current) {
		if ((ret = ipd_enqueue_iptcp(current->entry)) < 0)
			return ret;
		current = current->next;
	}
	return 0;
}

int ipd_clear_iptcp() {
	return write_proc("\203", 1);
}

int ipd_clear_ip() {
	return write_proc("\201", 1);
}

int ipd_clear_tcp() {
	return write_proc("\202", 1);
}

int ipd_iptcp_queue_length() {
	int fd = open_proc();
	int len = 0;
	char* readstr;

	if (fd < 0)
		return -1;
	readstr = read_until_string(fd, "IP/TCP Entries: ");
	if (readstr == NULL)
		return -1;
	free(readstr);
	readstr = read_until_string(fd, "\t");
	if (readstr == NULL)
		return -1;
	close(fd);
	readstr[strlen(readstr) - 1] = '\0';

	len = atoi(readstr);
	free(readstr);
	return len;
}

iptcplistentry* ipd_iptcp_read_queue() {
	int queuelength = ipd_iptcp_queue_length();
	int fd;
	iptcplistentry* head = NULL;
	iptcplistentry* current = NULL;
	char* readbuf;
	char* ipaddr;
	char mask;
	char repeat;
	char priority;
	iptcpdata data;
	char useip;
	char usetcp;
	int nibble1, nibble2, nibble3, nibble4;
	char* tempbuf;

	if (queuelength <= 0)
		return NULL;

	head = malloc(sizeof(iptcplistentry));
	if (head == NULL)
		return NULL;
	current = head;
	current->next = NULL;
	current->entry = NULL;

	if ((fd = open_proc()) < 0) {
		free(head);
		return NULL;
	}
	readbuf = read_until_string(fd, "\n");
	if (readbuf == NULL) {
		free(head);
		close(fd);
		return NULL;
	}
	free(readbuf);

	while (queuelength > 0) {
		readbuf = read_until_string(fd, "/");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		ipaddr = readbuf;
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		readbuf = strsep(&readbuf, " ");
		mask = atoi(readbuf);
		free(readbuf);
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		priority = atoi(readbuf);
		readbuf = read_until_string(fd, ",");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		tempbuf = readbuf;
		if ((nibble1 = strip_hex_nibble(&tempbuf)) < 0 || (nibble2 = strip_hex_nibble(&tempbuf)) < 0 || (nibble3 = strip_hex_nibble(&tempbuf)) < 0 || (nibble4 = strip_hex_nibble(&tempbuf)) < 0) {
			free(readbuf);
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		data.message[0] = nibble1 * 16 + nibble2;
		data.message[1] = nibble3 * 16 + nibble4;
		free(readbuf);
		readbuf = read_until_string(fd, ",");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		data.flagip = atoi(readbuf);
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		tempbuf = readbuf;
		if ((nibble1 = strip_hex_nibble(&tempbuf)) < 0) {
			free(readbuf);
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		data.flagstcp = nibble1;
		free(readbuf);
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		tempbuf = readbuf + 1;
		if (strncmp(tempbuf, "Inf", 3) == 0)
			repeat = -1;
		else
			repeat = atoi(tempbuf);
		free(readbuf);
		readbuf = read_until_string(fd, "\n");
		if (readbuf == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		if (strstr(readbuf, "I"))
			useip = 1;
		else
			useip = 0;
		if (strstr(readbuf, "T"))
			usetcp = 1;
		else
			usetcp = 0;
		free(readbuf);

		current->entry = ipd_create_iptcp_entry(ipaddr, mask, repeat, priority, data, useip, usetcp);
		free(ipaddr);
		if (current->entry == NULL) {
			ipd_iptcp_free_list(head);
			close(fd);
			return NULL;
		}
		if (--queuelength > 0) {
			current->next = malloc(sizeof(iptcplistentry));
			if (current->next == NULL) {
				ipd_iptcp_free_list(head);
				close(fd);
				return NULL;
			}
			current = current->next;
			current->next = NULL;
			current->entry = NULL;
		}
	}
	close(fd);

	return head;
}

void ipd_iptcp_free_list(iptcplistentry* head) {
	iptcplistentry* temp;
	while (head) {
		temp = head;
		if (head->entry)
			free(head->entry);
		head = temp->next;
		free(temp);
	}
}

int ipd_set_arp_send(arpethdata data) {
	char buffer[62];

	buffer[0] = 4;
	if (data.length > 60 || data.length < 0)
		return -1;
	buffer[1] = data.length;
	memcpy(&(buffer[2]), data.message, data.length);

	return write_proc(buffer, data.length + 2);
}

int ipd_clear_arp() {
	return write_proc("\204", 1);
}

arpethdata* ipd_read_arp_send() {
	int iptcpql = ipd_iptcp_queue_length();
	int queuelength = ipd_eth_queue_length();
	int fd;
	char* readbuf;
	char length;
	int curlen = 0;
	int readlen;
	arpethdata* data;

	if (queuelength < 0 || iptcpql < 0)
		return NULL;

	if ((fd = open_proc()) < 0)
		return NULL;
	while (iptcpql >= 0) {
		readbuf = read_until_string(fd, "\n");
		if (readbuf == NULL) {
			close(fd);
			return NULL;
		}
		free(readbuf);
		iptcpql--;
	}

	while (queuelength > 0) {
		readbuf = read_until_string(fd, "x");
		if (readbuf == NULL) {
			close(fd);
			return NULL;
		}
		free(readbuf);
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			close(fd);
			return NULL;
		}
		free(readbuf);
		readbuf = read_until_string(fd, ":");
		if (readbuf == NULL) {
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		length = atoi(readbuf);
		free(readbuf);
		readbuf = read_size(fd, length);
		if (readbuf == NULL) {
			close(fd);
			return NULL;
		}
		free(readbuf);
		readbuf = read_until_string(fd, "\n");
		if (readbuf == NULL) {
			close(fd);
			return NULL;
		}
		free(readbuf);
		queuelength--;
	}

	data = malloc(sizeof(arpethdata));
	if (data == NULL) {
		close(fd);
		return NULL;
	}

	while (curlen < 60 && (readlen = read(fd, data->message + curlen, 1)) > 0)
		curlen++;

	close(fd);

	if (readlen < 0) {
		free(data);
		return NULL;
	}

	if (readlen == 0)
		curlen--;

	data->length = curlen;

	return data;
}

ethentry* ipd_create_eth_entry(char* macaddr, char mask, char repeat, char priority, __u16 protocol, arpethdata data) {
	ethentry* entry;
	char* parsedmac;

	if (check_mac_addr(macaddr) < 0)
		return NULL;
	if (mask < 0 || mask > 48)
		return NULL;
	if (data.length < 0 || data.length > 60)
		return NULL;
	entry = malloc(sizeof(ethentry));
	if (entry == NULL)
		return NULL;

	parsedmac = parse_mac_addr(macaddr);
	if (parsedmac == NULL) {
		free(entry);
		return NULL;
	}
	memcpy(entry->macaddr, parsedmac, 6);
	free(parsedmac);
	entry->mask = (unsigned char)mask;
	entry->repeat = repeat;
	entry->priority = priority;
	entry->protocol = protocol;
	entry->data = data;

	return entry;
}

int ipd_enqueue_eth(ethentry* entry) {
	char buffer[73];

	buffer[0] = 8;
	memcpy(&(buffer[1]), entry->macaddr, 6);
	if (entry->mask > 48)
		return -1;
	buffer[7] = (char)(entry->mask);
	buffer[8] = entry->repeat;
	buffer[9] = entry->priority;
	memcpy(&(buffer[10]), &(entry->protocol), 2);
	if (entry->data.length < 0 || entry->data.length > 60)
		return -1;
	buffer[12] = entry->data.length;
	memcpy(&(buffer[13]), entry->data.message, entry->data.length);

	return write_proc(buffer, entry->data.length + 13);
}

int ipd_enqueue_eth_list(ethlistentry* head) {
	ethlistentry* current = head;
	int ret;
	while (current) {
		if ((ret = ipd_enqueue_eth(current->entry)) < 0)
			return ret;
		current = current->next;
	}
	return 0;
}

int ipd_clear_eth() {
	return write_proc("\210", 1);
}

int ipd_eth_queue_length() {
	int fd = open_proc();
	int len = 0;
	char* readstr;

	if (fd < 0)
		return -1;
	readstr = read_until_string(fd, "ETH Entries: ");
	if (readstr == NULL)
		return -1;
	free(readstr);
	readstr = read_until_string(fd, "\n");
	if (readstr == NULL)
		return -1;
	close(fd);
	readstr[strlen(readstr) - 1] = '\0';

	len = atoi(readstr);
	free(readstr);
	return len;
}

ethlistentry* ipd_eth_read_queue() {
	int iptcpql = ipd_iptcp_queue_length();
	int queuelength = ipd_eth_queue_length();
	int fd;
	ethlistentry* head = NULL;
	ethlistentry* current = NULL;
	char* readbuf;
	char* macaddr;
	char mask;
	char repeat;
	char priority;
	__u16 protocol;
	arpethdata data;
	int nibble1, nibble2, nibble3, nibble4;
	char* tempbuf;

	if (queuelength <= 0 || iptcpql < 0)
		return NULL;

	head = malloc(sizeof(ethlistentry));
	if (head == NULL)
		return NULL;
	current = head;
	current->next = NULL;
	current->entry = NULL;

	if ((fd = open_proc()) < 0) {
		free(head);
		return NULL;
	}
	while (iptcpql >= 0) {
		readbuf = read_until_string(fd, "\n");
		if (readbuf == NULL) {
			free(head);
			close(fd);
			return NULL;
		}
		free(readbuf);
		iptcpql--;
	}

	while (queuelength > 0) {
		readbuf = read_until_string(fd, "/");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		macaddr = readbuf;
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		readbuf = strsep(&readbuf, " ");
		mask = atoi(readbuf);
		free(readbuf);
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		priority = atoi(readbuf);
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		tempbuf = readbuf;
		if ((nibble1 = strip_hex_nibble(&tempbuf)) < 0 || (nibble2 = strip_hex_nibble(&tempbuf)) < 0 || (nibble3 = strip_hex_nibble(&tempbuf)) < 0 || (nibble4 = strip_hex_nibble(&tempbuf)) < 0) {
			free(readbuf);
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		protocol = nibble1 * 4096 + nibble2 * 256 + nibble3 * 16 + nibble4;
		free(readbuf);
		readbuf = read_until_string(fd, "x");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		if (strncmp(readbuf, "Inf", 3) == 0)
			repeat = -1;
		else
			repeat = atoi(readbuf);
		free(readbuf);
		readbuf = read_until_string(fd, "\t");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		free(readbuf);
		readbuf = read_until_string(fd, ":");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		readbuf[strlen(readbuf) - 1] = '\0';
		data.length = atoi(readbuf);
		free(readbuf);
		readbuf = read_size(fd, data.length);
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		memcpy(data.message, readbuf, data.length);
		free(readbuf);
		readbuf = read_until_string(fd, "\n");
		if (readbuf == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		free(readbuf);

		current->entry = ipd_create_eth_entry(macaddr, mask, repeat, priority, protocol, data);
		free(macaddr);
		if (current->entry == NULL) {
			ipd_eth_free_list(head);
			close(fd);
			return NULL;
		}
		if (--queuelength > 0) {
			current->next = malloc(sizeof(ethlistentry));
			if (current->next == NULL) {
				ipd_eth_free_list(head);
				close(fd);
				return NULL;
			}
			current = current->next;
			current->next = NULL;
			current->entry = NULL;
		}
	}
	close(fd);

	return head;
}

void ipd_eth_free_list(ethlistentry* head) {
	ethlistentry* temp;
	while (head) {
		temp = head;
		if (head->entry)
			free(head->entry);
		head = temp->next;
		free(temp);
	}
}
