#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <linux/types.h>

#define PROC_DIR "/proc/ipd/"

typedef enum message_type {ARP, IP_DFRAG, TCP_URGENT} message_type;

typedef struct tcp_message_t {
	__u32 saddr;
	__u32 daddr;
	int srcport;
	int dstport;

	int flag;	
	char message[2];

	struct timeval timestamp;
//	struct tcp_message_queue_t * next;
//	struct tcp_message_queue_t * prev;
} tcp_message_t;


typedef struct ip_message_t {
	__u32 saddr;
	__u32 daddr;

	int flag;
	char message[2];
	struct timeval timestamp;

//	struct ip_message_queue_t * next;
//	struct ip_message_queue_t * prev;
} ip_message_t;


typedef struct arp_message_t {
	__u32 saddr;
	__u32 daddr;

	char message[60];
	struct timeval timestamp;

//	struct arp_message_queue_t * next;
//	struct arp_message_queue_t * prev;
} arp_message_t;


typedef union message_t {
	tcp_message_t * tcp_msg;
	ip_message_t * ip_msg;
	arp_message_t * arp_msg;
} message_t;

typedef struct message_queue_t {
	message_t msg;
	struct message_queue_t * next;
	struct message_queue_t * prev;
} message_queue_t;

typedef struct ipd_receiver_t {
	int num_msgs;
	char * filename;

	message_type type;
	message_queue_t *msg_queue;
	message_queue_t *msg_queue_tail;
} ipd_receiver_t;



int ipd_add_receiver(const char * address, int netmask, message_type type, char * filename, int clear);
int ipd_delete_receiver(char * filename);

ipd_receiver_t * retrieve_messages(char * filename);

int ipd_delete_queue(char * filename);
void ipd_free_queue(ipd_receiver_t * q);
