#include "ipdrecv_ctrl.h"

#ifdef TEST
int main(int argc, char ** argv) {
	char foo;

	printf(":> ");
	while (foo = fgetc(stdin)) {
		fflush(stdout);
		if (foo == 'A') {
			ipd_add_receiver("192.168.1.102", 32, TCP_URGENT, "mytcp", 0);
		} else if (foo == 'D') {
			ipd_delete_receiver("mytcp");
		} else if (foo == 'R') {
			retrieve_messages("mytcp");
		} else if (foo == 'Q') {
			break;
		} else if (foo == '\n') {
			continue;
		}
		printf(":> ");
	}
return 0;
}

#endif // !TEST


void ipd_free_queue(ipd_receiver_t * q) {
	message_queue_t * temp = q->msg_queue;

	while (temp != NULL) {
		message_queue_t * holder;
		if (q->type == ARP) {
			free(temp->msg.arp_msg);
		} else if (q->type == TCP_URGENT) {
			free(temp->msg.tcp_msg);
		} else if (q->type == IP_DFRAG) {
			free(temp->msg.ip_msg);
		}
		holder = temp;
		temp = temp->next;
		free(holder);
	}
	free(q);
}


int ipd_delete_receiver(char * filename) {
	FILE * ipd_ctrl;
	char * buf;

	if (strpbrk(filename, " ;")) {
		return -1;
	}

	buf = malloc(strlen(filename) + 6);
	snprintf(buf, strlen(filename) + 5, "del %s", filename);
	ipd_ctrl = fopen("/proc/ipd_ctrl", "w");

	if (ipd_ctrl == NULL) {
		#ifdef TEST
		printf("File /proc/ipd_ctrl does not exist\n");
		#endif
		free(buf);
		return -1;
	}

	#ifdef TEST
	printf("%s\n", buf);
	#endif

	fprintf(ipd_ctrl, "%s", buf);
	fflush(ipd_ctrl);
	fclose(ipd_ctrl);

	free(buf);
	return 0;
}

int ipd_add_receiver(const char * address, int netmask, message_type type, char * filename, int clear) {
	int temp, i, len = 4;
	char * buf;
	FILE * ipd_ctrl;

	if (strlen(address) > 15) 
		return -1;

	buf = (char*)malloc(strlen(address) + 1);
	strncpy(buf, address, strlen(address)+1);

	for (i = 0; i < 3; i++) {
		temp = atoi(strsep(&buf, "."));
		if ((temp < 0) || (temp > 254)) {
			return -1;
		}
	}

	temp = atoi(buf);
	if ((temp < 0) || (temp > 254)) {
		return -1;
	}

	len += strlen(address) + 1;

	if ((netmask < 0) || (netmask > 32)) {
		return -1;
	}

	len += 4;

	if (strpbrk(filename, " ;") != NULL) {
		return -1;
	}

	len += strlen(filename) + 1;

	if ((clear != 0) && (clear != 1)) {
		return -1;
	}

	len += 3;

	if (type == ARP) {
		buf = malloc(len + strlen("ARP  M"));
		snprintf(buf, len + strlen("ARP  M") - 1, "add %s/%d ARP %s %c M", address, netmask, filename, (clear == 1) ? 'Y' : 'N');
	} else if (type == IP_DFRAG) {
		buf = malloc(len + strlen("IP_DFRAG  M"));
		snprintf(buf, len + strlen("IP_DFRAG  M") - 1, "add %s/%d IP_DFRAG %s %c M", address, netmask, filename, (clear == 1) ? 'Y' : 'N');
	} else if (type == TCP_URGENT) {
		buf = malloc(len + strlen("TCP_URGENT  M"));
		snprintf(buf, len + strlen("TCP_URGENT  M") - 1, "add %s/%d TCP_URGENT %s %c M", address, netmask, filename, (clear == 1) ? 'Y' : 'N');
	}

	#ifdef TEST
	printf("%s\n", buf);
	#endif

	ipd_ctrl = fopen("/proc/ipd_ctrl", "w");
	if (ipd_ctrl == NULL) {
		#ifdef TEST
		printf("File /proc/ipd_ctrl does not exist\n");
		#endif
		return -1;
	}

	fprintf(ipd_ctrl, "%s", buf);
	fflush(ipd_ctrl);
	fclose(ipd_ctrl);

	free(buf);
return 0;
}


ipd_receiver_t * retrieve_messages(char * filename) {
	FILE * proc_file;
	int i = 0;
	char type;
	ipd_receiver_t * rcv;
	char * path_name;

	path_name = (char*)malloc(strlen(filename) + strlen(PROC_DIR) + 1);
	snprintf(path_name, strlen(filename) + strlen(PROC_DIR) + 1, "%s%s", PROC_DIR, filename);

	proc_file = fopen(path_name, "r");
	if (proc_file == NULL) {
		#ifdef TEST
		printf("Could not open file for read: %s\n", path_name);

		#endif 
		return NULL;
	}

	rcv = (ipd_receiver_t *)malloc(sizeof(ipd_receiver_t));
	rcv->filename = (char*)malloc(strlen(filename)+1);
	strncpy(rcv->filename, filename, strlen(filename));

	fread(&type, sizeof(char), 1, proc_file);
	fread(&(rcv->num_msgs), sizeof(int), 1, proc_file);

	rcv->type = type;
	rcv->msg_queue = NULL;
	rcv->msg_queue_tail = NULL;

	#ifdef TEST
	printf("%d - %d\n", rcv->num_msgs, rcv->type);
	#endif

	for (i=0; i < rcv->num_msgs; i++) {
		if (rcv->type == ARP) {
			int msg_num;
			arp_message_t * arp_msg;
			message_queue_t * msg_q;
			
			arp_msg = (arp_message_t *)malloc(sizeof(arp_message_t));
			msg_q = (message_queue_t*)malloc(sizeof(message_queue_t));
			msg_q->msg.arp_msg = arp_msg;
			msg_q->next = NULL;
			msg_q->prev = NULL;

			fread(&msg_num, sizeof(int), 1, proc_file);
			fread(&(arp_msg->timestamp.tv_sec), sizeof(long), 1, proc_file);
			fread(&(arp_msg->timestamp.tv_usec), sizeof(long), 1, proc_file);
			fread(&(arp_msg->saddr), sizeof(__u32), 1, proc_file);
			fread(&(arp_msg->daddr), sizeof(__u32), 1, proc_file);
			fread(&(arp_msg->message), sizeof(char), 60, proc_file);

			if (rcv->msg_queue == NULL) {
				rcv->msg_queue = msg_q;
				rcv->msg_queue_tail = msg_q;
			} else {
				rcv->msg_queue_tail->next = msg_q;
				msg_q->prev = rcv->msg_queue_tail;
				rcv->msg_queue_tail = msg_q;
			}
		} else if (rcv->type == IP_DFRAG) {
			int msg_num;
			ip_message_t * ip_msg;
			message_queue_t * msg_q;

			ip_msg = (ip_message_t *)malloc(sizeof(ip_message_t));
			msg_q = (message_queue_t*)malloc(sizeof(message_queue_t));
			msg_q->msg.ip_msg = ip_msg;
			msg_q->next = NULL;
			msg_q->prev = NULL;

			fread(&msg_num, sizeof(int), 1, proc_file);
			fread(&(ip_msg->timestamp.tv_sec), sizeof(long), 1, proc_file);
			fread(&(ip_msg->timestamp.tv_usec), sizeof(long), 1, proc_file);
			fread(&(ip_msg->saddr), sizeof(__u32), 1, proc_file);
			fread(&(ip_msg->daddr), sizeof(__u32), 1, proc_file);
			fread(&(ip_msg->message[0]), sizeof(char), 1, proc_file);
			fread(&(ip_msg->message[1]), sizeof(char), 1, proc_file);
			fread(&(ip_msg->flag), sizeof(int), 1, proc_file);

			if (rcv->msg_queue == NULL) {
				rcv->msg_queue = msg_q;
				rcv->msg_queue_tail = msg_q;
			} else {
				rcv->msg_queue_tail->next = msg_q;
				msg_q->prev = rcv->msg_queue_tail;
				rcv->msg_queue_tail = msg_q;
			}
		} else if (rcv->type == TCP_URGENT) {
			int msg_num;
			tcp_message_t * tcp_msg;
			message_queue_t * msg_q;

			tcp_msg = (tcp_message_t *)malloc(sizeof(tcp_message_t));		
			msg_q = (message_queue_t*)malloc(sizeof(message_queue_t));
			msg_q->msg.tcp_msg = tcp_msg;
			msg_q->next = NULL;
			msg_q->prev = NULL;

			fread(&msg_num, sizeof(int), 1, proc_file);
			fread(&(tcp_msg->timestamp.tv_sec), sizeof(long), 1, proc_file);
			fread(&(tcp_msg->timestamp.tv_usec), sizeof(long), 1, proc_file);
			fread(&(tcp_msg->saddr), sizeof(__u32), 1, proc_file);
			fread(&(tcp_msg->srcport), sizeof(__u16), 1, proc_file);
			fread(&(tcp_msg->daddr), sizeof(__u32), 1, proc_file);
			fread(&(tcp_msg->dstport), sizeof(__u16), 1, proc_file);
			fread(&(tcp_msg->message[0]), sizeof(char), 1, proc_file);
			fread(&(tcp_msg->message[1]), sizeof(char), 1, proc_file);
			fread(&(tcp_msg->flag), sizeof(int), 1, proc_file);

			if (rcv->msg_queue == NULL) {
				rcv->msg_queue = msg_q;	
				rcv->msg_queue_tail = msg_q;
			} else {
				rcv->msg_queue_tail->next = msg_q;
				msg_q->prev = rcv->msg_queue_tail;
				rcv->msg_queue_tail = msg_q;
			}
		}
	}

#ifdef TEST
{
	message_queue_t * msg_q = rcv->msg_queue;
	for (i=0; i < rcv->num_msgs; i++) {

		if (rcv->type == ARP) {
			printf("%d -- %ld.%ld - %x - %x - %s\n", i, 
					msg_q->msg.arp_msg->timestamp.tv_sec, \
					msg_q->msg.arp_msg->timestamp.tv_usec, msg_q->msg.arp_msg->saddr, \
					 msg_q->msg.arp_msg->daddr, msg_q->msg.arp_msg->message);
		} else if (rcv->type == IP_DFRAG) {
			printf("%d -- %ld.%ld - %x - %x - %c%c:%d\n", i, msg_q->msg.ip_msg->timestamp.tv_sec, \
				msg_q->msg.ip_msg->timestamp.tv_usec, msg_q->msg.ip_msg->saddr, \
				msg_q->msg.ip_msg->daddr, msg_q->msg.ip_msg->message[0], \
				msg_q->msg.ip_msg->message[1], msg_q->msg.ip_msg->flag);
		} else if (rcv->type == TCP_URGENT) {
			printf("%d -- %ld.%ld - %x:%d - %x:%d - %x%x\n", i , msg_q->msg.tcp_msg->timestamp.tv_sec, \
				msg_q->msg.tcp_msg->timestamp.tv_usec, \
				msg_q->msg.tcp_msg->saddr, msg_q->msg.tcp_msg->srcport, \
				msg_q->msg.tcp_msg->daddr, msg_q->msg.tcp_msg->dstport, \
				msg_q->msg.tcp_msg->message[0], msg_q->msg.tcp_msg->message[1]);
		}
		msg_q = msg_q->next;
	}

}
#endif
	fclose(proc_file);

return rcv;
}

int ipd_delete_queue(char * filename) {
	FILE * proc_file;
	proc_file = fopen(filename, "w");
	fprintf(proc_file, "A");
	fclose(proc_file);

return 0;
}
